/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation;

import java.util.StringTokenizer;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.obligation.ObligationHandler;
import org.glite.authz.pep.obligation.ObligationService;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniOHConfigurationParserHelper {
    public static final String OH_PROP = "obligationHandlers";
    private static final Logger LOG = LoggerFactory.getLogger(IniOHConfigurationParserHelper.class);

    public static ObligationService processObligationHandlers(Ini iniFile, Profile.Section configSection, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        ObligationService service = new ObligationService();
        if (configSection.containsKey((Object)OH_PROP)) {
            StringTokenizer obligationHandlers = new StringTokenizer((String)configSection.get((Object)OH_PROP), " ");
            while (obligationHandlers.hasMoreTokens()) {
                String obligationHandlerName = Strings.safeTrimOrNullString((String)obligationHandlers.nextToken());
                if (obligationHandlerName == null) continue;
                if (!iniFile.containsKey((Object)obligationHandlerName)) {
                    String errorMsg = "INI configuration file does not contain a configuration section for obligation handler " + obligationHandlerName;
                    LOG.error(errorMsg);
                    throw new ConfigurationException(errorMsg);
                }
                ObligationHandler oh = IniOHConfigurationParserHelper.buildObligationHandler((Profile.Section)iniFile.get((Object)obligationHandlerName), configBuilder);
                service.addObligationhandler(oh);
                LOG.info("Added obligation handler: {}", (Object)obligationHandlerName);
            }
        }
        return service;
    }

    private static ObligationHandler buildObligationHandler(Profile.Section ohConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        LOG.info("Loading Obligation Handler {}", (Object)ohConfig.getName());
        String parserClassName = IniConfigUtil.getString((Profile.Section)ohConfig, (String)"parserClass");
        try {
            Class<?> parserClass = IniOHConfigurationParserHelper.class.getClassLoader().loadClass(parserClassName);
            IniSectionConfigurationParser parser = (IniSectionConfigurationParser)parserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (ObligationHandler)parser.parse(ohConfig, configBuilder);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to configure Obligation Handler " + ohConfig.getName() + ". The following error was reported: " + e.getMessage(), e);
        }
    }
}

