/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation;

import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.obligation.ObligationHandler;

@ThreadSafe
public abstract class AbstractObligationHandler
implements ObligationHandler {
    private String id_;
    private String obligationId_;
    private int precedence_;

    protected AbstractObligationHandler(String obligationId) {
        this(obligationId, obligationId);
    }

    protected AbstractObligationHandler(String name, String obligationId) {
        this(name, obligationId, 0);
    }

    protected AbstractObligationHandler(String name, String obligationId, int handlerPrecedence) {
        this.setId(name);
        this.obligationId_ = Strings.safeTrimOrNullString((String)obligationId);
        if (this.obligationId_ == null) {
            throw new IllegalArgumentException("Provided obligation ID may not be null or empty");
        }
        if (handlerPrecedence < 0) {
            throw new IllegalArgumentException("Handler precedence must be 0 or greater");
        }
        this.precedence_ = handlerPrecedence;
    }

    public String getObligationId() {
        return this.obligationId_;
    }

    public int getHandlerPrecedence() {
        return this.precedence_;
    }

    protected void setHanderPrecedence(int precedence) {
        this.precedence_ = precedence;
    }

    public String getId() {
        return this.id_;
    }

    protected void setId(String id) {
        String tempId = Strings.safeTrimOrNullString((String)id);
        if (tempId == null) {
            throw new IllegalArgumentException("Obligation Handler ID may not be null or empty");
        }
        this.id_ = tempId;
    }

    public int hashCode() {
        return this.getObligationId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ObligationHandler) {
            return Strings.safeEquals((Object)this.getObligationId(), (Object)((ObligationHandler)obj).getObligationId());
        }
        return false;
    }
}

