/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.model.util;

import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.AttributeAssignment;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.Status;
import org.glite.authz.common.model.StatusCode;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.model.util.Strings;
import org.opensaml.Configuration;
import org.opensaml.xacml.XACMLObjectBuilder;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResourceContentType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusCodeType;
import org.opensaml.xacml.ctx.StatusMessageType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xacml.policy.AttributeAssignmentType;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xml.XMLObjectBuilder;

public class XACMLConverter {
    private static XACMLObjectBuilder<StatusCodeType> statusCodeBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(StatusCodeType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<StatusType> statusBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(StatusType.DEFAULT_ELEMENT_NAME);
    private static XMLObjectBuilder<StatusMessageType> statusMessageBuilder = Configuration.getBuilderFactory().getBuilder(StatusMessageType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ObligationsType> obligationsBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ObligationsType.DEFAULT_ELEMENT_QNAME);
    private static XACMLObjectBuilder<ObligationType> obligationBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ObligationType.DEFAULT_ELEMENT_QNAME);
    private static XACMLObjectBuilder<AttributeAssignmentType> attributeAssignmentBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(AttributeAssignmentType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResultType> resultBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResultType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<DecisionType> decisionBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(DecisionType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResponseType> responseBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResponseType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<AttributeType> attributeBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(AttributeType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<AttributeValueType> attributeValueBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(AttributeValueType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ActionType> actionBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ActionType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<EnvironmentType> environmentBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(EnvironmentType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResourceType> resourceBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResourceType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResourceContentType> resourceContentBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResourceContentType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<SubjectType> subjectBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(SubjectType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<RequestType> requestBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(RequestType.DEFAULT_ELEMENT_NAME);

    public static final Action actionFromXACML(ActionType xacmlAction) {
        if (xacmlAction == null) {
            return null;
        }
        Action action = new Action();
        if (xacmlAction.getAttributes() != null) {
            for (AttributeType xacmlAttribute : xacmlAction.getAttributes()) {
                action.getAttributes().add(XACMLConverter.attributeFromXACML(xacmlAttribute));
            }
        }
        return action;
    }

    public static final ActionType actionToXACML(Action action) {
        if (action == null) {
            return null;
        }
        ActionType xacmlAction = (ActionType)actionBuilder.buildObject();
        if (action.getAttributes() != null) {
            for (Attribute attribute : action.getAttributes()) {
                xacmlAction.getAttributes().add(XACMLConverter.attributeToXACML(attribute));
            }
        }
        return xacmlAction;
    }

    public static final Attribute attributeFromXACML(AttributeType xacmlAttribute) {
        if (xacmlAttribute == null) {
            return null;
        }
        Attribute attribute = new Attribute();
        attribute.setDataType(Strings.safeTrimOrNullString((String)xacmlAttribute.getDataType()));
        attribute.setId(Strings.safeTrimOrNullString((String)xacmlAttribute.getAttributeID()));
        attribute.setIssuer(Strings.safeTrimOrNullString((String)xacmlAttribute.getIssuer()));
        if (xacmlAttribute.getAttributeValues() != null) {
            for (AttributeValueType xacmlAttributeValue : xacmlAttribute.getAttributeValues()) {
                String value = xacmlAttributeValue.getValue();
                if (value == null) continue;
                attribute.getValues().add(Strings.safeTrimOrNullString((String)xacmlAttributeValue.getValue()));
            }
        }
        return attribute;
    }

    public static final AttributeType attributeToXACML(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        AttributeType xacmlAttribute = (AttributeType)attributeBuilder.buildObject();
        xacmlAttribute.setAttributeID(Strings.safeTrimOrNullString((String)attribute.getId()));
        String datatype = Strings.safeTrimOrNullString((String)attribute.getDataType());
        if (datatype != null) {
            xacmlAttribute.setDataType(datatype);
        } else {
            xacmlAttribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        }
        xacmlAttribute.setIssuer(Strings.safeTrimOrNullString((String)attribute.getIssuer()));
        if (attribute.getValues() != null) {
            for (Object attributeValue : attribute.getValues()) {
                String value = Strings.safeTrimOrNullString((String)attributeValue.toString());
                if (value == null) continue;
                AttributeValueType xacmlAttributeValue = (AttributeValueType)attributeValueBuilder.buildObject();
                xacmlAttributeValue.setValue(value);
                xacmlAttribute.getAttributeValues().add(xacmlAttributeValue);
            }
        }
        return xacmlAttribute;
    }

    public static final Environment environmentFromXACML(EnvironmentType xacmlEnvironment) {
        if (xacmlEnvironment == null) {
            return null;
        }
        Environment environment = new Environment();
        if (xacmlEnvironment.getAttributes() != null) {
            for (AttributeType xacmlAttribute : xacmlEnvironment.getAttributes()) {
                environment.getAttributes().add(XACMLConverter.attributeFromXACML(xacmlAttribute));
            }
        }
        return environment;
    }

    public static final EnvironmentType environmentToXACML(Environment environment) {
        if (environment == null) {
            return null;
        }
        EnvironmentType xacmlEnvironment = (EnvironmentType)environmentBuilder.buildObject();
        if (environment.getAttributes() != null) {
            for (Attribute attribute : environment.getAttributes()) {
                xacmlEnvironment.getAttributes().add(XACMLConverter.attributeToXACML(attribute));
            }
        }
        return xacmlEnvironment;
    }

    public static final Obligation obligationFromXACML(ObligationType xacmlObligation) {
        if (xacmlObligation == null) {
            return null;
        }
        Obligation obligation = new Obligation();
        if (xacmlObligation.getAttributeAssignments() != null) {
            for (AttributeAssignmentType xacmlAttributeAssignment : xacmlObligation.getAttributeAssignments()) {
                AttributeAssignment attributeAssignment = new AttributeAssignment();
                attributeAssignment.setAttributeId(Strings.safeTrimOrNullString((String)xacmlAttributeAssignment.getAttributeId()));
                attributeAssignment.setDataType(Strings.safeTrimOrNullString((String)xacmlAttributeAssignment.getDataType()));
                attributeAssignment.setValue(Strings.safeTrimOrNullString((String)xacmlAttributeAssignment.getValue()));
            }
        }
        switch (xacmlObligation.getFulfillOn()) {
            case Deny: {
                obligation.setFulfillOn(0);
                break;
            }
            case Permit: {
                obligation.setFulfillOn(1);
            }
        }
        obligation.setId(Strings.safeTrimOrNullString((String)xacmlObligation.getObligationId()));
        return obligation;
    }

    public static final ObligationType obligationToXACML(Obligation obligation) {
        if (obligation == null) {
            return null;
        }
        ObligationType xacmlObligation = (ObligationType)obligationBuilder.buildObject();
        if (obligation.getAttributeAssignments() != null) {
            for (AttributeAssignment attributeAssignment : obligation.getAttributeAssignments()) {
                attributeAssignment = (AttributeAssignment)obligation.getAttributeAssignments().get(0);
                AttributeAssignmentType xacmlAttributeAssignment = (AttributeAssignmentType)attributeAssignmentBuilder.buildObject();
                xacmlAttributeAssignment.setAttributeId(Strings.safeTrimOrNullString((String)attributeAssignment.getAttributeId()));
                xacmlAttributeAssignment.setDataType(attributeAssignment.getDataType());
                xacmlAttributeAssignment.setValue(attributeAssignment.getValue());
            }
        }
        if (obligation.getFulfillOn() == 1) {
            xacmlObligation.setFulfillOn(EffectType.Permit);
        } else {
            xacmlObligation.setFulfillOn(EffectType.Deny);
        }
        xacmlObligation.setObligationId(Strings.safeTrimOrNullString((String)obligation.getId()));
        return xacmlObligation;
    }

    public static final Request requestFromXACML(RequestType xacmlRequest) {
        Request request = new Request();
        request.setAction(XACMLConverter.actionFromXACML(xacmlRequest.getAction()));
        request.setEnvironment(XACMLConverter.environmentFromXACML(xacmlRequest.getEnvironment()));
        if (xacmlRequest.getResources() != null) {
            for (ResourceType xacmlResource : xacmlRequest.getResources()) {
                request.getResources().add(XACMLConverter.resourceFromXACML(xacmlResource));
            }
        }
        if (xacmlRequest.getSubjects() != null) {
            for (SubjectType xacmlSubject : xacmlRequest.getSubjects()) {
                request.getSubjects().add(XACMLConverter.subjectFromXACML(xacmlSubject));
            }
        }
        return request;
    }

    public static final RequestType requestToXACML(Request request) {
        if (request == null) {
            return null;
        }
        RequestType xacmlRequest = (RequestType)requestBuilder.buildObject();
        xacmlRequest.setAction(XACMLConverter.actionToXACML(request.getAction()));
        xacmlRequest.setEnvironment(XACMLConverter.environmentToXACML(request.getEnvironment()));
        if (request.getResources() != null) {
            for (Resource resource : request.getResources()) {
                xacmlRequest.getResources().add(XACMLConverter.resourceToXACML(resource));
            }
        }
        if (request.getSubjects() != null) {
            for (Subject subject : request.getSubjects()) {
                xacmlRequest.getSubjects().add(XACMLConverter.subjectToXACML(subject));
            }
        }
        return xacmlRequest;
    }

    public static final Resource resourceFromXACML(ResourceType xacmlResource) {
        if (xacmlResource == null) {
            return null;
        }
        Resource resource = new Resource();
        if (xacmlResource.getResourceContent() != null) {
            resource.setResourceContent(Strings.safeTrimOrNullString((String)xacmlResource.getResourceContent().getValue()));
        }
        if (xacmlResource.getAttributes() != null) {
            for (AttributeType xacmlAttribute : xacmlResource.getAttributes()) {
                resource.getAttributes().add(XACMLConverter.attributeFromXACML(xacmlAttribute));
            }
        }
        return resource;
    }

    public static final ResourceType resourceToXACML(Resource resource) {
        if (resource == null) {
            return null;
        }
        ResourceType xacmlResource = (ResourceType)resourceBuilder.buildObject();
        if (!Strings.isEmpty((String)resource.getResourceContent())) {
            ResourceContentType xacmlResourceContent = (ResourceContentType)resourceContentBuilder.buildObject();
            xacmlResourceContent.setValue(Strings.safeTrimOrNullString((String)resource.getResourceContent()));
            xacmlResource.setResourceContent(xacmlResourceContent);
        }
        if (resource.getAttributes() != null) {
            for (Attribute attribute : resource.getAttributes()) {
                xacmlResource.getAttributes().add(XACMLConverter.attributeToXACML(attribute));
            }
        }
        return xacmlResource;
    }

    public static final Response responseFromXACML(ResponseType xacmlResponse, RequestType xacmlRequest) {
        if (xacmlResponse == null) {
            return null;
        }
        Response response = new Response();
        response.getResults().add(XACMLConverter.resultFromXACML(xacmlResponse.getResult()));
        if (xacmlRequest != null) {
            response.setRequest(XACMLConverter.requestFromXACML(xacmlRequest));
        }
        return response;
    }

    public static final ResponseType responseToXACML(Response response) {
        if (response == null) {
            return null;
        }
        ResponseType xacmlResponse = (ResponseType)responseBuilder.buildObject();
        xacmlResponse.setResult(XACMLConverter.resultToXACML((Result)response.getResults().get(0)));
        return xacmlResponse;
    }

    public static final Result resultFromXACML(ResultType xacmlResult) {
        if (xacmlResult == null) {
            return null;
        }
        Result result = new Result();
        result.setResourceId(xacmlResult.getResourceId());
        switch (xacmlResult.getDecision().getDecision()) {
            case Deny: {
                result.setDecision(0);
                break;
            }
            case Indeterminate: {
                result.setDecision(2);
                break;
            }
            case NotApplicable: {
                result.setDecision(3);
                break;
            }
            case Permit: {
                result.setDecision(1);
            }
        }
        result.setStatus(XACMLConverter.statusFromXACML(xacmlResult.getStatus()));
        if (xacmlResult.getObligations() != null && xacmlResult.getObligations().getObligations() != null) {
            for (ObligationType xacmlObligation : xacmlResult.getObligations().getObligations()) {
                result.getObligations().add(XACMLConverter.obligationFromXACML(xacmlObligation));
            }
        }
        return result;
    }

    public static final ResultType resultToXACML(Result result) {
        if (result == null) {
            return null;
        }
        ResultType xacmlResult = (ResultType)resultBuilder.buildObject();
        DecisionType decision = (DecisionType)decisionBuilder.buildObject();
        switch (result.getDecision()) {
            case 0: {
                decision.setDecision(DecisionType.DECISION.Deny);
                break;
            }
            case 2: {
                decision.setDecision(DecisionType.DECISION.Indeterminate);
                break;
            }
            case 3: {
                decision.setDecision(DecisionType.DECISION.NotApplicable);
                break;
            }
            case 1: {
                decision.setDecision(DecisionType.DECISION.Permit);
            }
        }
        xacmlResult.setDecision(decision);
        xacmlResult.setStatus(XACMLConverter.statusToXACML(result.getStatus()));
        if (result.getObligations() != null) {
            ObligationsType xacmlObligations = (ObligationsType)obligationsBuilder.buildObject();
            for (Obligation obligation : result.getObligations()) {
                xacmlObligations.getObligations().add(XACMLConverter.obligationToXACML(obligation));
            }
            xacmlResult.setObligations(xacmlObligations);
        }
        return xacmlResult;
    }

    public static final StatusCode statusCodeFromXACML(StatusCodeType xacmlStatusCode) {
        if (xacmlStatusCode == null) {
            return null;
        }
        StatusCode statusCode = new StatusCode();
        statusCode.setCode(Strings.safeTrimOrNullString((String)xacmlStatusCode.getValue()));
        statusCode.setSubCode(XACMLConverter.statusCodeFromXACML(xacmlStatusCode.getStatusCode()));
        return statusCode;
    }

    public static final StatusCodeType statusCodeToXACML(StatusCode statusCode) {
        if (statusCode == null) {
            return null;
        }
        StatusCodeType xacmlStatusCode = (StatusCodeType)statusCodeBuilder.buildObject();
        xacmlStatusCode.setValue(Strings.safeTrimOrNullString((String)statusCode.getCode()));
        xacmlStatusCode.setStatusCode(XACMLConverter.statusCodeToXACML(statusCode.getSubCode()));
        return xacmlStatusCode;
    }

    public static final Status statusFromXACML(StatusType xacmlStatus) {
        if (xacmlStatus == null) {
            return null;
        }
        Status status = new Status();
        status.setCode(XACMLConverter.statusCodeFromXACML(xacmlStatus.getStatusCode()));
        if (xacmlStatus.getStatusMessage() != null) {
            status.setMessage(Strings.safeTrimOrNullString((String)xacmlStatus.getStatusMessage().getValue()));
        }
        return status;
    }

    public static final StatusType statusToXACML(Status status) {
        if (status == null) {
            return null;
        }
        StatusType xacmlStatus = (StatusType)statusBuilder.buildObject();
        xacmlStatus.setStatusCode(XACMLConverter.statusCodeToXACML(status.getCode()));
        if (!Strings.isEmpty((String)status.getMessage())) {
            StatusMessageType xacmlStatusMessage = (StatusMessageType)statusMessageBuilder.buildObject(StatusMessageType.DEFAULT_ELEMENT_NAME, StatusMessageType.TYPE_NAME);
            xacmlStatusMessage.setValue(Strings.safeTrimOrNullString((String)status.getMessage()));
            xacmlStatus.setStatusMessage(xacmlStatusMessage);
        }
        return xacmlStatus;
    }

    public static final Subject subjectFromXACML(SubjectType xacmlSubject) {
        if (xacmlSubject == null) {
            return null;
        }
        Subject subject = new Subject();
        subject.setCategory(Strings.safeTrimOrNullString((String)xacmlSubject.getSubjectCategory()));
        if (xacmlSubject.getAttributes() != null) {
            for (AttributeType xacmlAttribute : xacmlSubject.getAttributes()) {
                subject.getAttributes().add(XACMLConverter.attributeFromXACML(xacmlAttribute));
            }
        }
        return subject;
    }

    public static final SubjectType subjectToXACML(Subject subject) {
        if (subject == null) {
            return null;
        }
        SubjectType xacmlSubject = (SubjectType)subjectBuilder.buildObject();
        xacmlSubject.setSubjectCategory(Strings.safeTrimOrNullString((String)subject.getCategory()));
        if (subject.getAttributes() != null) {
            for (Attribute attribute : subject.getAttributes()) {
                xacmlSubject.getAttributes().add(XACMLConverter.attributeToXACML(attribute));
            }
        }
        return xacmlSubject;
    }
}

