/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.store.impl;

import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.italiangrid.voms.store.LSCInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSCFile
implements LSCInfo {
    String filename;
    String vo;
    String hostname;
    List<String> certChainDescription;

    @Override
    public String getVOName() {
        return this.vo;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public List<String> getCertificateChainDescription() {
        return this.certChainDescription;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public String getVo() {
        return this.vo;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setVo(String vo) {
        this.vo = vo;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setCertificateChainDescription(List<String> certChainDesc) {
        this.certChainDescription = certChainDesc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.vo == null ? 0 : this.vo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LSCFile other = (LSCFile)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        return !(this.vo == null ? other.vo != null : !this.vo.equals(other.vo));
    }

    public String toString() {
        return "LSCFile [filename=" + this.filename + ", vo=" + this.vo + ", hostname=" + this.hostname + ", certChainDescription=" + this.certChainDescription + "]";
    }

    @Override
    public boolean matches(X509Certificate[] certChain) {
        if (this.certChainDescription == null || this.certChainDescription.isEmpty()) {
            return false;
        }
        if (certChain == null || certChain.length == 0) {
            return false;
        }
        if (this.certChainDescription.size() == certChain.length * 2) {
            for (int i = 0; i < certChain.length; ++i) {
                String lscSubjectRFC2253 = OpensslNameUtils.opensslToRfc2253((String)this.certChainDescription.get(i));
                String lscIssuerRFC2253 = OpensslNameUtils.opensslToRfc2253((String)this.certChainDescription.get(i + 1));
                boolean subjectDoesMatch = X500NameUtils.equal((X500Principal)certChain[i].getSubjectX500Principal(), (String)lscSubjectRFC2253);
                boolean issuerDoesMatch = X500NameUtils.equal((X500Principal)certChain[i].getIssuerX500Principal(), (String)lscIssuerRFC2253);
                if (subjectDoesMatch && issuerDoesMatch) continue;
                return false;
            }
        }
        return true;
    }
}

