/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.DirectNIOBuffer;
import org.mortbay.io.nio.IndirectNIOBuffer;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.io.nio.SelectorManager;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.ServletSSL;
import org.mortbay.jetty.security.SslHttpChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public class SslSelectChannelConnector
extends SelectChannelConnector {
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    private String[] _excludeCipherSuites = null;
    private String _keystore = DEFAULT_KEYSTORE;
    private String _keystoreType = "JKS";
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private transient Password _password;
    private transient Password _keyPassword;
    private transient Password _trustPassword;
    private String _protocol = "TLS";
    private String _algorithm = "SunX509";
    private String _provider;
    private String _secureRandomAlgorithm;
    private String _sslKeyManagerFactoryAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    private String _sslTrustManagerFactoryAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    private String _truststore;
    private String _truststoreType = "JKS";
    private SSLContext _context;
    private int _packetBufferSize;
    private int _applicationBufferSize;
    private ConcurrentLinkedQueue<Buffer> _packetBuffers = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Buffer> _applicationBuffers = new ConcurrentLinkedQueue();

    public Buffer getBuffer(int size) {
        Buffer buffer;
        if (size == this._applicationBufferSize) {
            buffer = this._applicationBuffers.poll();
            if (buffer == null) {
                buffer = new IndirectNIOBuffer(size);
            }
        } else if (size == this._packetBufferSize) {
            buffer = this._packetBuffers.poll();
            if (buffer == null) {
                buffer = this.getUseDirectBuffers() ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
            }
        } else {
            buffer = super.getBuffer(size);
        }
        return buffer;
    }

    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        int size = buffer.capacity();
        ByteBuffer bbuf = ((NIOBuffer)buffer).getByteBuffer();
        bbuf.position(0);
        bbuf.limit(size);
        if (size == this._applicationBufferSize) {
            this._applicationBuffers.add(buffer);
        } else if (size == this._packetBufferSize) {
            this._packetBuffers.add(buffer);
        } else {
            super.returnBuffer(buffer);
        }
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException e) {
            Log.ignore((Throwable)e);
            return null;
        }
        catch (Exception e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            return null;
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        request.setScheme("https");
        SslHttpChannelEndPoint sslHttpChannelEndpoint = (SslHttpChannelEndPoint)endpoint;
        SSLEngine sslEngine = sslHttpChannelEndpoint.getSSLEngine();
        try {
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSession sslSession = sslEngine.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength((String)cipherSuite));
                certs = SslSelectChannelConnector.getCertChain(sslSession);
                cachedInfo = new CachedInfo(keySize, certs);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", (Object)certs);
            }
            request.setAttribute("javax.servlet.request.cipher_suite", (Object)cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", (Object)keySize);
        }
        catch (Exception e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
        }
    }

    public String[] getCipherSuites() {
        return this.getExcludeCipherSuites();
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.setExcludeCipherSuites(cipherSuites);
    }

    public void setExcludeCipherSuites(String[] cipherSuites) {
        this._excludeCipherSuites = cipherSuites;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword((String)PASSWORD_PROPERTY, (String)password, null);
    }

    public void setTrustPassword(String password) {
        this._trustPassword = Password.getPassword((String)PASSWORD_PROPERTY, (String)password, null);
    }

    public void setKeyPassword(String password) {
        this._keyPassword = Password.getPassword((String)KEYPASSWORD_PROPERTY, (String)password, null);
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setKeystore(String keystore) {
        this._keystore = keystore;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystoreType() {
        return this._keystoreType;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this._wantClientAuth = wantClientAuth;
    }

    public void setKeystoreType(String keystoreType) {
        this._keystoreType = keystoreType;
    }

    public String getProvider() {
        return this._provider;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslKeyManagerFactoryAlgorithm;
    }

    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslTrustManagerFactoryAlgorithm;
    }

    public String getTruststore() {
        return this._truststore;
    }

    public String getTruststoreType() {
        return this._truststoreType;
    }

    public void setProvider(String _provider) {
        this._provider = _provider;
    }

    public void setSecureRandomAlgorithm(String algorithm) {
        this._secureRandomAlgorithm = algorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslKeyManagerFactoryAlgorithm = algorithm;
    }

    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslTrustManagerFactoryAlgorithm = algorithm;
    }

    public void setTruststore(String truststore) {
        this._truststore = truststore;
    }

    public void setTruststoreType(String truststoreType) {
        this._truststoreType = truststoreType;
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return new SslHttpChannelEndPoint((Buffers)this, channel, selectSet, key, this.createSSLEngine());
    }

    protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
        HttpConnection connection = (HttpConnection)super.newConnection(channel, endpoint);
        ((HttpParser)connection.getParser()).setForceContentBuffer(true);
        return connection;
    }

    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine engine = null;
        try {
            engine = this._context.createSSLEngine();
            engine.setUseClientMode(false);
            if (this._wantClientAuth) {
                engine.setWantClientAuth(this._wantClientAuth);
            }
            if (this._needClientAuth) {
                engine.setNeedClientAuth(this._needClientAuth);
            }
            if (this._excludeCipherSuites != null && this._excludeCipherSuites.length > 0) {
                List<String> excludedCSList = Arrays.asList(this._excludeCipherSuites);
                String[] enabledCipherSuites = engine.getEnabledCipherSuites();
                ArrayList<String> enabledCSList = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
                for (String cipherName : excludedCSList) {
                    if (!enabledCSList.contains(cipherName)) continue;
                    enabledCSList.remove(cipherName);
                }
                enabledCipherSuites = enabledCSList.toArray(new String[enabledCSList.size()]);
                engine.setEnabledCipherSuites(enabledCipherSuites);
            }
        }
        catch (Exception e) {
            Log.warn((String)"Error creating sslEngine -- closing this connector", (Throwable)e);
            this.close();
            throw new IllegalStateException(e);
        }
        return engine;
    }

    protected void doStart() throws Exception {
        this._context = this.createSSLContext();
        SSLEngine engine = this.createSSLEngine();
        SSLSession ssl_session = engine.getSession();
        this.setHeaderBufferSize(ssl_session.getApplicationBufferSize());
        this.setRequestBufferSize(ssl_session.getApplicationBufferSize());
        this.setResponseBufferSize(ssl_session.getApplicationBufferSize());
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SSLContext createSSLContext() throws Exception {
        KeyStore trustStore;
        TrustManager[] trustManagers;
        KeyManager[] keyManagers;
        block10: {
            KeyStore keyStore;
            block9: {
                if (this._truststore == null) {
                    this._truststore = this._keystore;
                    this._truststoreType = this._keystoreType;
                }
                InputStream keystoreInputStream = null;
                keyManagers = null;
                keyStore = null;
                try {
                    if (this._keystore != null) {
                        keystoreInputStream = Resource.newResource((String)this._keystore).getInputStream();
                        keyStore = KeyStore.getInstance(this._keystoreType);
                        keyStore.load(keystoreInputStream, this._password == null ? null : this._password.toString().toCharArray());
                    }
                    Object var5_4 = null;
                    if (keystoreInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (keystoreInputStream != null) {
                        keystoreInputStream.close();
                    }
                    throw throwable;
                }
                keystoreInputStream.close();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._sslKeyManagerFactoryAlgorithm);
            keyManagerFactory.init(keyStore, this._keyPassword == null ? (this._password == null ? null : this._password.toString().toCharArray()) : this._keyPassword.toString().toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
            trustManagers = null;
            InputStream truststoreInputStream = null;
            trustStore = null;
            try {
                if (this._truststore != null) {
                    truststoreInputStream = Resource.newResource((String)this._truststore).getInputStream();
                    trustStore = KeyStore.getInstance(this._truststoreType);
                    trustStore.load(truststoreInputStream, this._trustPassword == null ? null : this._trustPassword.toString().toCharArray());
                }
                Object var9_10 = null;
                if (truststoreInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (truststoreInputStream != null) {
                    truststoreInputStream.close();
                }
                throw throwable;
            }
            truststoreInputStream.close();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._sslTrustManagerFactoryAlgorithm);
        trustManagerFactory.init(trustStore);
        trustManagers = trustManagerFactory.getTrustManagers();
        SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
        SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context;
    }

    private class CachedInfo {
        private java.security.cert.X509Certificate[] _certs;
        private Integer _keySize;

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs) {
            this._keySize = keySize;
            this._certs = certs;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }
    }
}

