/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.profile;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.util.Base64;
import org.glite.authz.pep.profile.AbstractAuthorizationProfile;
import org.glite.authz.pep.profile.AuthorizationProfile;
import org.glite.authz.pep.profile.ProfileException;

public final class CommonXACMLAuthorizationProfile
extends AbstractAuthorizationProfile
implements AuthorizationProfile {
    private static CommonXACMLAuthorizationProfile SINGLETON = null;

    public Subject createSubjectKeyInfo(X509Certificate cert, X509Certificate[] chain) throws ProfileException {
        ArrayList<X509Certificate> x509s = new ArrayList<X509Certificate>();
        if (cert != null) {
            x509s.add(cert);
        }
        if (chain != null) {
            for (X509Certificate chainCert : chain) {
                x509s.add(chainCert);
            }
        }
        Attribute attrKeyInfo = new Attribute();
        attrKeyInfo.setId(this.getSubjectKeyInfoAttributeIdentifer());
        attrKeyInfo.setDataType(this.getSubjectKeyInfoAttributeDatatype());
        for (X509Certificate x509 : x509s) {
            try {
                byte[] derBytes = x509.getEncoded();
                String base64Binary = Base64.encodeBytes(derBytes);
                attrKeyInfo.getValues().add(base64Binary);
            }
            catch (CertificateEncodingException e) {
                throw new ProfileException("Can not convert certificate to base64 binary format", e);
            }
        }
        Subject subject = new Subject();
        subject.getAttributes().add(attrKeyInfo);
        return subject;
    }

    public String getProfileIdAttributeIdentifer() {
        return "http://dci-sec.org/xacml/attribute/profile-id";
    }

    protected String getSubjectKeyInfoAttributeDatatype() {
        return "http://www.w3.org/2001/XMLSchema#base64Binary";
    }

    public String getMapUserToPOSIXEnvironmentObligationIdentifier() {
        return "http://dci-sec.org/xacml/obligation/map-local-user/posix";
    }

    public String getUserIdAttributeAssignmentIdentifier() {
        return "http://dci-sec.org/xacml/attribute/user-id";
    }

    public String getGroupIdAttributeAssignmentIdentifier() {
        return "http://dci-sec.org/xacml/attribute/group-id";
    }

    public String getPrimaryGroupIdAttributeAssignmentIdentifier() {
        return "http://dci-sec.org/xacml/attribute/group-id/primary";
    }

    private CommonXACMLAuthorizationProfile() {
        super("http://dci-sec.org/xacml/profile/common-authz/1.1");
    }

    public static synchronized CommonXACMLAuthorizationProfile getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new CommonXACMLAuthorizationProfile();
        }
        return SINGLETON;
    }
}

