/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.http;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glite.authz.common.http.AbstractAdminCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShutdownCommand
extends AbstractAdminCommand {
    private static final long serialVersionUID = 8098511780458295197L;
    private final Logger log = LoggerFactory.getLogger(ShutdownCommand.class);
    private Thread shutdownThread;

    public ShutdownCommand(final List<Runnable> shutdownTasks) {
        super("shutdown");
        if (shutdownTasks == null || shutdownTasks.isEmpty()) {
            return;
        }
        this.shutdownThread = new Thread(){

            public void run() {
                for (Runnable shutdownTask : shutdownTasks) {
                    shutdownTask.run();
                }
            }
        };
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.flushBuffer();
        this.log.info("Service shutting down...");
        if (this.shutdownThread != null) {
            this.shutdownThread.start();
        }
    }
}

