/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.http;

import org.glite.authz.common.http.ShutdownTask;
import org.mortbay.jetty.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServerShutdownTask
implements ShutdownTask {
    private Logger log = LoggerFactory.getLogger(JettyServerShutdownTask.class);
    private Server httpServer;

    public JettyServerShutdownTask(Server targetServer) {
        this.httpServer = targetServer;
    }

    public void run() {
        if (this.httpServer.isRunning()) {
            try {
                this.httpServer.stop();
                if (this.httpServer.isStopped()) {
                    this.log.info("Server stopped.");
                }
            }
            catch (Exception e) {
                this.log.error("Unable to shutdown HTTP server", (Throwable)e);
                System.exit(1);
            }
        }
    }
}

