/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.context;

import java.security.NoSuchAlgorithmException;
import org.glite.authz.common.context.DecisionRequestContext;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.ws.soap.client.SOAPClient;
import org.opensaml.ws.soap.client.http.HttpSOAPRequestParameters;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionQueryType;
import org.opensaml.xml.XMLObject;

public class DecisionRequestContextHelper {
    private static IdentifierGenerator idGenerator;
    private static SAMLObjectBuilder<XACMLAuthzDecisionQueryType> authzDecisionQueryBuilder;
    private static SOAPObjectBuilder<Body> bodyBuilder;
    private static SOAPObjectBuilder<Envelope> envelopeBuilder;
    private static SAMLObjectBuilder<Issuer> issuerBuilder;

    public static DecisionRequestContext buildMessageContext(String messageIssuerId) {
        DecisionRequestContext messageContext = new DecisionRequestContext();
        messageContext.setCommunicationProfileId("urn:mace:switch.ch:doc:xacml-saml:profile:200711:SOAP");
        messageContext.setOutboundMessageIssuer(messageIssuerId);
        messageContext.setSOAPRequestParameters((SOAPClient.SOAPRequestParameters)new HttpSOAPRequestParameters("http://www.oasis-open.org/committees/security"));
        return messageContext;
    }

    public static Envelope buildSOAPMessage(String messageIssuerId, DecisionRequestContext messageContext, RequestType xacmlRequest) {
        XACMLAuthzDecisionQueryType samlRequest = (XACMLAuthzDecisionQueryType)authzDecisionQueryBuilder.buildObject(XACMLAuthzDecisionQueryType.DEFAULT_ELEMENT_NAME_XACML20, XACMLAuthzDecisionQueryType.TYPE_NAME_XACML20);
        samlRequest.setRequest(xacmlRequest);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        issuer.setValue(messageIssuerId);
        samlRequest.setIssuer(issuer);
        samlRequest.setID(idGenerator.generateIdentifier());
        samlRequest.setIssueInstant(new DateTime());
        samlRequest.setInputContextOnly(Boolean.valueOf(false));
        samlRequest.setReturnContext(Boolean.valueOf(true));
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(samlRequest);
        Envelope envelope = (Envelope)envelopeBuilder.buildObject();
        envelope.setBody(body);
        messageContext.setOutboundMessage((XMLObject)envelope);
        messageContext.setOutboundMessageId(samlRequest.getID());
        return envelope;
    }

    static {
        authzDecisionQueryBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(XACMLAuthzDecisionQueryType.TYPE_NAME_XACML20);
        bodyBuilder = (SOAPObjectBuilder)Configuration.getBuilderFactory().getBuilder(Body.TYPE_NAME);
        envelopeBuilder = (SOAPObjectBuilder)Configuration.getBuilderFactory().getBuilder(Envelope.TYPE_NAME);
        issuerBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        try {
            idGenerator = new SecureRandomIdentifierGenerator();
            idGenerator.generateIdentifier();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

