/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.config;

import java.util.ArrayList;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.util.Strings;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniConfigUtil {
    private static Logger log = LoggerFactory.getLogger(IniConfigUtil.class);
    public static final String STRING_LIST_SEPARATOR = " ";

    public static boolean getBoolean(Profile.Section configSection, String propName, boolean defaultValue) {
        String value = IniConfigUtil.getString(configSection, propName, null);
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultValue;
    }

    public static boolean getBoolean(Profile.Section configSection, String propName) throws ConfigurationException {
        String value = IniConfigUtil.getString(configSection, propName, null);
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            return false;
        }
        throw new ConfigurationException("INI configuration section " + configSection.getName() + " does not contain the required property " + propName);
    }

    public static String getString(Profile.Section configSection, String propName, String defaultValue) {
        String propValue = Strings.safeTrimOrNullString((String)configSection.get((Object)propName));
        if (propValue == null) {
            propValue = defaultValue;
        }
        return propValue;
    }

    public static String getString(Profile.Section configSection, String propName) throws ConfigurationException {
        String propValue = Strings.safeTrimOrNullString((String)configSection.get((Object)propName));
        if (propValue != null) {
            return propValue;
        }
        throw new ConfigurationException("INI configuration section " + configSection.getName() + " does not contain the required property " + propName);
    }

    public static int getInt(Profile.Section configSection, String propName, int minValue, int maxValue) throws ConfigurationException {
        if (configSection.containsKey((Object)propName)) {
            try {
                int tempInt = Integer.parseInt((String)configSection.get((Object)propName));
                if (tempInt < minValue) {
                    throw new ConfigurationException(propName + " must be greater than " + minValue);
                }
                if (tempInt > maxValue) {
                    throw new ConfigurationException(propName + " must be less than " + maxValue);
                }
                return tempInt;
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(propName + " is not a valid integer");
            }
        }
        throw new ConfigurationException("INI configuration section " + configSection.getName() + " does not contain the required property " + propName);
    }

    public static int getInt(Profile.Section configSection, String propName, int defaultValue, int minValue, int maxValue) {
        String strValue = Strings.safeTrimOrNullString((String)configSection.get((Object)propName));
        if (strValue != null) {
            try {
                int tempInt = Integer.parseInt(strValue);
                if (tempInt >= minValue && tempInt <= maxValue) {
                    return tempInt;
                }
                log.warn("Property {} in configuration section {} with a value of {} was not greater than or equal to {} and less than or equal to {}, using default value of {}", new Object[]{propName, configSection.getName(), tempInt, minValue, maxValue, defaultValue});
            }
            catch (NumberFormatException e) {
                log.warn("Property {} in configuration section {} was not a valid integer, using default value of {}, using default value of {}", new Object[]{propName, configSection.getName(), strValue, defaultValue});
            }
        }
        return defaultValue;
    }

    public static String[] getStringsArray(Profile.Section configSection, String propName) throws ConfigurationException {
        return IniConfigUtil.getStringsArray(configSection, propName, STRING_LIST_SEPARATOR);
    }

    public static String[] getStringsArray(Profile.Section configSection, String propName, String[] defaultValues) {
        String[] values = null;
        try {
            values = IniConfigUtil.getStringsArray(configSection, propName, STRING_LIST_SEPARATOR);
        }
        catch (ConfigurationException e) {
            return defaultValues;
        }
        return values;
    }

    private static String[] getStringsArray(Profile.Section configSection, String propName, String listSeparator) throws ConfigurationException {
        String propValues = (String)configSection.get((Object)propName);
        if (propValues == null) {
            throw new ConfigurationException("INI configuration section " + configSection.getName() + " does not contain the required property " + propName);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String value : propValues.split(listSeparator)) {
            String trimmedValue = Strings.safeTrimOrNullString(value);
            if (trimmedValue == null) continue;
            values.add(trimmedValue);
        }
        return values.toArray(new String[values.size()]);
    }
}

