/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common;

import java.io.PrintWriter;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.util.Strings;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

@ThreadSafe
public class ServiceMetrics {
    private Runtime runtime = Runtime.getRuntime();
    private String serviceId;
    private String serviceVersion;
    private long startupTime;
    private long totalRequests;
    private long totalErrors;

    public ServiceMetrics(String id, String version) {
        this.serviceId = Strings.safeTrimOrNullString(id);
        this.serviceVersion = Strings.safeTrimOrNullString(version);
        this.startupTime = System.currentTimeMillis();
        this.totalRequests = 0L;
        this.totalErrors = 0L;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public long getServiceStartupTime() {
        return this.startupTime;
    }

    public long getTotalServiceRequests() {
        return this.totalRequests;
    }

    public void incrementTotalServiceRequests() {
        ++this.totalRequests;
    }

    public long getTotalServiceRequestErrors() {
        return this.totalErrors;
    }

    public void incrementTotalServiceRequestErrors() {
        ++this.totalErrors;
    }

    public void printServiceMetrics(PrintWriter writer) {
        long maxMemory = this.runtime.maxMemory();
        long usedMemory = this.runtime.totalMemory() - this.runtime.freeMemory();
        writer.println("Status: OK");
        writer.println("Service: " + this.serviceId);
        writer.println("ServiceVersion: " + this.serviceVersion);
        writer.println("ServiceStartupTime: " + new DateTime(this.startupTime).withChronology((Chronology)ISOChronology.getInstanceUTC()));
        writer.println("ServiceStartupTimeMillis: " + this.startupTime);
        writer.println("NumberOfProcessors: " + this.runtime.availableProcessors());
        writer.println("MaxMemory: " + maxMemory + " bytes");
        writer.println("UsedMemory: " + usedMemory + " bytes");
        writer.println("TotalRequests: " + this.getTotalServiceRequests());
        writer.println("TotalCompletedRequests: " + (this.getTotalServiceRequests() - this.getTotalServiceRequestErrors()));
        writer.println("TotalRequestErrors: " + this.getTotalServiceRequestErrors());
    }
}

