/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.glite.authz.common.util.Strings;

public final class Files {
    private Files() {
    }

    public static File getReadableFile(String filePath) throws IOException {
        return Files.getFile(filePath, true, true, true, false);
    }

    public static File getFile(String filePath, boolean requireFile, boolean requireExistance, boolean requireReadable, boolean requireWritable) throws IOException {
        String path = Strings.safeTrimOrNullString(filePath);
        if (path == null) {
            throw new IOException("The file path may not be empty");
        }
        File file = new File(filePath);
        if (requireExistance && !file.exists()) {
            throw new IOException("The file '" + filePath + "' does not exist.");
        }
        if (requireFile && !file.isFile()) {
            throw new IOException("The path '" + filePath + "' is a directory not a file");
        }
        if (requireReadable && !file.canRead()) {
            throw new IOException("The file '" + filePath + "' is not readable.");
        }
        if (requireWritable && !file.canWrite()) {
            throw new IOException("The file '" + filePath + "' is not writable.");
        }
        return file;
    }

    public static byte[] fileToByteArray(File file) throws IOException {
        long numOfBytes = file.length();
        if (numOfBytes > Integer.MAX_VALUE) {
            throw new IOException("File is to large to be read in to a byte array");
        }
        byte[] bytes = new byte[(int)numOfBytes];
        FileInputStream ins = new FileInputStream(file);
        int offset = 0;
        int numRead = 0;
        while ((offset += (numRead = ins.read(bytes, offset, bytes.length - offset))) < bytes.length && numRead >= 0) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ins.close();
        return bytes;
    }
}

