/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.http;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.glite.authz.common.util.Strings;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.slf4j.LoggerFactory;

public class JettyAdminServiceCLI {
    public static final int RC_SUCCESS = 0;
    public static final int RC_BAD_ARGUMENTS = 1;
    public static final int RC_CTX = 2;
    public static final int RC_INVALID_COMMAND = 3;
    public static final int RC_UNAUTHORIZED = 4;
    public static final int RC_UNKNOWN = 100;

    public static void main(String[] args) {
        if (args.length < 3) {
            JettyAdminServiceCLI.exit("Invalid command line arguments", 1);
        }
        JettyAdminServiceCLI.disableLibraryLogging();
        String host = JettyAdminServiceCLI.parseHost(args[0]);
        int port = JettyAdminServiceCLI.parsePort(args[1]);
        String command = JettyAdminServiceCLI.parseCommand(args[2]);
        String password = null;
        if (args.length == 4) {
            password = Strings.safeTrimOrNullString(args[3]);
        }
        JettyAdminServiceCLI.executeCommand(host, port, command, password);
        JettyAdminServiceCLI.exit(null, 0);
    }

    private static void disableLibraryLogging() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = lc.getLogger("ROOT");
        rootLogger.setLevel(Level.OFF);
    }

    private static String parseHost(String hostArgument) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(hostArgument);
            return addresses[0].getHostName();
        }
        catch (UnknownHostException e) {
            JettyAdminServiceCLI.exit("The host argument is not a valid hostname or IP address", 1);
            return null;
        }
    }

    private static int parsePort(String portArgument) {
        try {
            int port = Integer.parseInt(portArgument);
            if (port < 1 || port > 65535) {
                JettyAdminServiceCLI.exit("Port number is not valid", 1);
            }
            return port;
        }
        catch (NumberFormatException e) {
            JettyAdminServiceCLI.exit("Port number is not valid", 1);
            return 0;
        }
    }

    private static String parseCommand(String commandArgument) {
        String argument = Strings.safeTrimOrNullString(commandArgument);
        if (argument == null) {
            JettyAdminServiceCLI.exit("Command argument is not valid", 1);
        }
        return argument;
    }

    private static void executeCommand(String host, int port, String command, String password) {
        HttpClientBuilder clientBuilder = new HttpClientBuilder();
        HttpClient httpClient = clientBuilder.buildClient();
        GetMethod getMethod = new GetMethod("http://" + host + ":" + port + "/" + command);
        if (password != null) {
            getMethod.setQueryString(new NameValuePair[]{new NameValuePair("password", password)});
        }
        try {
            httpClient.executeMethod((HttpMethod)getMethod);
            String response = Strings.safeTrimOrNullString(getMethod.getResponseBodyAsString());
            if (response != null) {
                System.out.println(response);
            }
        }
        catch (ConnectException e) {
            JettyAdminServiceCLI.exit("Unable to connect to " + host + ":" + port + ", perhaps the service is not running", 2);
        }
        catch (IOException e) {
            JettyAdminServiceCLI.exit("Error executing service command:\n" + e.getMessage(), 2);
        }
        int statusCode = getMethod.getStatusCode();
        if (statusCode == 200) {
            return;
        }
        if (statusCode == 401) {
            JettyAdminServiceCLI.exit("you are not authorized to execute admin commands; invalid password", 4);
        } else {
            JettyAdminServiceCLI.exit("Service returned unexpected HTTP status code; " + statusCode, 100);
        }
    }

    private static void exit(String message, int returnCode) {
        if (message != null) {
            System.err.println(message);
        }
        System.exit(returnCode);
    }
}

