/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.http;

import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.glite.authz.common.http.AbstractAdminCommand;
import org.glite.authz.common.http.JettyRunThread;
import org.glite.authz.common.http.JettyServerShutdownTask;
import org.glite.authz.common.http.PasswordProtectFilter;
import org.glite.authz.common.http.ShutdownCommand;
import org.glite.authz.common.http.ShutdownTask;
import org.glite.authz.common.util.LazyList;
import org.glite.authz.common.util.Strings;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.BlockingChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;

public class JettyAdminService {
    private Server adminService;
    private String adminHost;
    private int adminPort;
    private String adminPassword;
    private List<AbstractAdminCommand> adminCommands;
    private List<ShutdownTask> shutdownTasks;

    public JettyAdminService(String hostname, int port, String password) {
        this.adminHost = Strings.safeTrimOrNullString(hostname);
        if (this.adminHost == null) {
            throw new IllegalArgumentException("Admin service hostname may not be null");
        }
        this.adminPort = port;
        if (this.adminPort < 1) {
            throw new IllegalArgumentException("Admin port must be greater than 0");
        }
        if (this.adminPort > 65535) {
            throw new IllegalArgumentException("Admin port must be less than 65536");
        }
        this.adminPassword = Strings.safeTrimOrNullString(password);
        this.adminService = this.buildAdminService();
        this.adminCommands = new LazyList<AbstractAdminCommand>();
        this.shutdownTasks = new LazyList<ShutdownTask>();
    }

    public void registerAdminCommand(AbstractAdminCommand command) {
        if (command == null) {
            return;
        }
        if (this.adminService.isRunning()) {
            throw new IllegalStateException("Admin service is already running");
        }
        for (AbstractAdminCommand adminCommand : this.adminCommands) {
            if (!adminCommand.getCommandPath().equals(command.getCommandPath())) continue;
            throw new IllegalArgumentException("Another admin command is already registered under the path " + command.getCommandPath());
        }
        this.adminCommands.add(command);
    }

    public void registerShutdownTask(ShutdownTask task) {
        if (task == null) {
            return;
        }
        if (this.adminService.isRunning()) {
            throw new IllegalStateException("Admin service is already running");
        }
        this.shutdownTasks.add(task);
    }

    public synchronized void start() {
        if (this.adminService.isRunning()) {
            throw new IllegalStateException("Admin service is already running");
        }
        Context commandContext = new Context((HandlerContainer)this.adminService, "/", false, false);
        this.adminCommands.add(this.buildShutdownCommand());
        for (AbstractAdminCommand command : this.adminCommands) {
            ServletHolder servletHolder = new ServletHolder((Servlet)command);
            commandContext.addServlet(servletHolder, command.getCommandPath());
        }
        if (this.adminPassword != null) {
            FilterHolder passwordFiler = new FilterHolder((Filter)new PasswordProtectFilter(this.adminPassword));
            commandContext.addFilter(passwordFiler, "/*", 1);
        }
        JettyRunThread shutdownServiceRunThread = new JettyRunThread(this.adminService);
        shutdownServiceRunThread.start();
    }

    protected Server buildAdminService() {
        this.adminService = new Server();
        this.adminService.setSendServerVersion(false);
        this.adminService.setSendDateHeader(false);
        this.adminService.setStopAtShutdown(true);
        BlockingChannelConnector connector = new BlockingChannelConnector();
        connector.setHost(this.adminHost);
        connector.setPort(this.adminPort);
        this.adminService.setConnectors(new Connector[]{connector});
        return this.adminService;
    }

    protected AbstractAdminCommand buildShutdownCommand() {
        LazyList<Runnable> augmentedShutdownTasks = new LazyList<Runnable>();
        augmentedShutdownTasks.addAll(this.shutdownTasks);
        augmentedShutdownTasks.add(new JettyServerShutdownTask(this.adminService));
        return new ShutdownCommand(augmentedShutdownTasks);
    }
}

