/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.config;

import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.AbstractServiceConfiguration;
import org.glite.authz.common.util.Strings;
import org.opensaml.ws.soap.client.SOAPClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceConfigurationBuilder<ConfigType extends AbstractServiceConfiguration>
extends AbstractConfigurationBuilder<ConfigType> {
    private String entityId;
    private String hostname;
    private int port;
    private boolean sslEnabled;
    private boolean clientCertAuthRequired;
    private String adminHost;
    private int adminPort;
    private String adminPassword;
    private int maxRequestQueueSize;
    private SOAPClient soapClient;

    protected AbstractServiceConfigurationBuilder() {
        this.entityId = null;
        this.hostname = null;
        this.port = 0;
        this.sslEnabled = false;
        this.clientCertAuthRequired = false;
        this.adminHost = null;
        this.adminPort = 0;
        this.adminPassword = null;
        this.maxRequestQueueSize = 0;
        this.soapClient = null;
    }

    protected AbstractServiceConfigurationBuilder(AbstractServiceConfiguration prototype) {
        super(prototype);
        this.entityId = prototype.getEntityId();
        this.hostname = prototype.getHostname();
        this.port = prototype.getPort();
        this.sslEnabled = prototype.isSslEnabled();
        this.clientCertAuthRequired = prototype.isClientCertAuthRequired();
        this.adminHost = prototype.getAdminHost();
        this.adminPort = prototype.getAdminPort();
        this.adminPassword = prototype.getAdminPassword();
        this.maxRequestQueueSize = prototype.getMaxRequestQueueSize();
        this.soapClient = prototype.getSOAPClient();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public int getPort() {
        return this.port;
    }

    public String getAdminHost() {
        return this.adminHost;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public SOAPClient getSOAPClient() {
        return this.soapClient;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public boolean isClientCertAuthRequired() {
        return this.clientCertAuthRequired;
    }

    @Override
    protected void populateConfiguration(ConfigType config) {
        super.populateConfiguration(config);
        ((AbstractServiceConfiguration)config).setEntityId(this.entityId);
        ((AbstractServiceConfiguration)config).setHostname(this.hostname);
        ((AbstractServiceConfiguration)config).setPort(this.port);
        ((AbstractServiceConfiguration)config).setSslEnabled(this.sslEnabled);
        ((AbstractServiceConfiguration)config).setClientCertAuthRequired(this.clientCertAuthRequired);
        ((AbstractServiceConfiguration)config).setAdminHost(this.adminHost);
        ((AbstractServiceConfiguration)config).setAdminPort(this.adminPort);
        ((AbstractServiceConfiguration)config).setAdminPassword(this.adminPassword);
        ((AbstractServiceConfiguration)config).setMaxRequestQueueSize(this.maxRequestQueueSize);
        ((AbstractServiceConfiguration)config).setSOAPClient(this.soapClient);
    }

    public void setEntityId(String id) {
        this.entityId = Strings.safeTrimOrNullString(id);
    }

    public void setHost(String newHost) {
        if (Strings.isEmpty(newHost)) {
            throw new IllegalArgumentException("Host may not be null or empty");
        }
        this.hostname = newHost;
    }

    public void setMaxRequestQueueSize(int max) {
        this.maxRequestQueueSize = max;
    }

    public void setPort(int newPort) {
        this.port = newPort;
    }

    public void setAdminHost(String host) {
        this.adminHost = host;
    }

    public void setAdminPort(int newPort) {
        this.adminPort = newPort;
    }

    public void setAdminPassword(String password) {
        this.adminPassword = password;
    }

    public void setSoapClient(SOAPClient client) {
        if (client == null) {
            throw new IllegalArgumentException("SOAP client may not be null");
        }
        this.soapClient = client;
    }

    public void setSslEnabled(boolean enabled) {
        this.sslEnabled = enabled;
    }

    public void setClientCertAuthRequired(boolean required) {
        this.clientCertAuthRequired = required;
    }
}

