/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.config;

import org.glite.authz.common.ServiceMetrics;
import org.glite.authz.common.config.AbstractConfiguration;
import org.opensaml.ws.soap.client.SOAPClient;

public abstract class AbstractServiceConfiguration
extends AbstractConfiguration {
    private ServiceMetrics serviceMetrics;
    private String entityId;
    private String hostname;
    private int port;
    private Boolean sslEnabled;
    private Boolean clientCertAuthRequired;
    private String adminHost;
    private int adminPort;
    private String adminPassword;
    private int maxRequestQueueSize;
    private SOAPClient soapClient;

    protected AbstractServiceConfiguration(ServiceMetrics metrics) {
        this.serviceMetrics = metrics;
        this.hostname = null;
        this.port = 0;
        this.sslEnabled = null;
        this.adminHost = null;
        this.adminPort = 0;
        this.adminPassword = null;
        this.maxRequestQueueSize = 0;
        this.soapClient = null;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isClientCertAuthRequired() {
        return this.clientCertAuthRequired == null ? false : this.clientCertAuthRequired;
    }

    public int getMaxRequestQueueSize() {
        return this.maxRequestQueueSize;
    }

    public int getPort() {
        return this.port;
    }

    public ServiceMetrics getServiceMetrics() {
        return this.serviceMetrics;
    }

    public String getAdminHost() {
        return this.adminHost;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public SOAPClient getSOAPClient() {
        return this.soapClient;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled == null ? false : this.sslEnabled;
    }

    protected final synchronized void setEntityId(String id) {
        if (this.entityId != null) {
            throw new IllegalStateException("Entity ID has already been set, it may not be changed");
        }
        this.entityId = id;
    }

    protected final synchronized void setHostname(String newHost) {
        if (this.hostname != null) {
            throw new IllegalArgumentException("Hostname has already been set, it may be changed");
        }
        this.hostname = newHost;
    }

    protected final synchronized void setClientCertAuthRequired(boolean required) {
        if (this.clientCertAuthRequired != null) {
            throw new IllegalStateException("Client cert authentication requirement has already been set, it may not be changed");
        }
        this.clientCertAuthRequired = required;
    }

    protected final synchronized void setMaxRequestQueueSize(int max) {
        if (this.maxRequestQueueSize != 0) {
            throw new IllegalStateException("Max request size has already been set, it may not be changed");
        }
        this.maxRequestQueueSize = max;
    }

    protected final synchronized void setPort(int newPort) {
        if (this.port != 0) {
            throw new IllegalStateException("Service port number has already been set, it may not be changed");
        }
        this.port = newPort;
    }

    protected final synchronized void setAdminHost(String host) {
        if (this.adminHost != null) {
            throw new IllegalStateException("Admin hostname has alrady been set, it may not be changed.");
        }
        this.adminHost = host;
    }

    protected final synchronized void setAdminPort(int port) {
        if (this.adminPort != 0) {
            throw new IllegalStateException("Admin service port has already been set, it may not be changed");
        }
        this.adminPort = port;
    }

    protected final synchronized void setAdminPassword(String password) {
        if (this.adminPassword != null) {
            throw new IllegalStateException("Admin password has alrady been set, it may not be changed.");
        }
        this.adminPassword = password;
    }

    protected final synchronized void setSOAPClient(SOAPClient client) {
        if (this.soapClient != null) {
            throw new IllegalStateException("SOAP client has already been set, it may not be changed");
        }
        this.soapClient = client;
    }

    protected final synchronized void setSslEnabled(boolean enabled) {
        if (this.sslEnabled != null) {
            throw new IllegalStateException("SSL enablement of service port has already been set, it may not be changed");
        }
        this.sslEnabled = enabled;
    }
}

