/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.config;

import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.IOException;
import javax.net.ssl.X509KeyManager;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.config.AbstractConfiguration;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.ConfigurationParser;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.util.Files;
import org.glite.authz.common.x509.TrustStoreValidationErrorLogger;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractIniConfigurationParser<ConfigurationType extends AbstractConfiguration>
implements ConfigurationParser<ConfigurationType> {
    public static final String SECURITY_SECTION_HEADER = "SECURITY";
    public static final String SERVICE_KEY_PROP = "servicePrivateKey";
    public static final String SERVICE_KEY_PASSWORD_PROP = "servicePrivateKeyPassword";
    public static final String SERVICE_CERT_PROP = "serviceCertificate";
    public static final String TRUST_INFO_DIR_PROP = "trustInfoDir";
    public static final String TRUST_INFO_REFRSH_PROP = "trustInfoRefresh";
    public static final String MAX_REQUESTS_PROP = "maximumRequests";
    public static final String CONN_TIMEOUT_PROP = "connectionTimeout";
    public static final String REC_BUFF_SIZE_PROP = "receiveBufferSize";
    public static final String SEND_BUFF_SIZE_PROP = "sendBufferSize";
    public static final int DEFAULT_TRUST_INFO_REFRESH = 60;
    public static final int DEFAULT_MAX_REQS = 200;
    public static final int DEFAULT_CONN_TIMEOUT = 30;
    public static final int DEFAULT_REC_BUFF_SIZE = 16384;
    public static final int DEFAULT_SEND_BUFF_SIZE = 16384;
    private final Logger log = LoggerFactory.getLogger(AbstractIniConfigurationParser.class);

    protected int getConnectionTimeout(Profile.Section configSection) {
        int timeout = IniConfigUtil.getInt(configSection, CONN_TIMEOUT_PROP, 30, 1, Integer.MAX_VALUE);
        return timeout * 1000;
    }

    protected int getMaximumRequests(Profile.Section configSection) {
        return IniConfigUtil.getInt(configSection, MAX_REQUESTS_PROP, 200, 1, Integer.MAX_VALUE);
    }

    protected int getReceiveBufferSize(Profile.Section configSection) {
        return IniConfigUtil.getInt(configSection, REC_BUFF_SIZE_PROP, 16384, 1, Integer.MAX_VALUE);
    }

    protected int getSendBufferSize(Profile.Section configSection) {
        return IniConfigUtil.getInt(configSection, SEND_BUFF_SIZE_PROP, 16384, 1, Integer.MAX_VALUE);
    }

    protected int getTrustMaterialRefreshInterval(Profile.Section configSection) {
        return IniConfigUtil.getInt(configSection, TRUST_INFO_REFRSH_PROP, 60, 1, Integer.MAX_VALUE);
    }

    protected X509KeyManager getX509KeyManager(Profile.Section configSection) throws ConfigurationException {
        if (configSection == null) {
            return null;
        }
        String name = configSection.getName();
        String privateKeyFilePath = IniConfigUtil.getString(configSection, SERVICE_KEY_PROP, null);
        if (privateKeyFilePath == null) {
            this.log.info("{}: No service private key file provided, no service credential will be used.", (Object)name);
            return null;
        }
        String certificateFilePath = IniConfigUtil.getString(configSection, SERVICE_CERT_PROP, null);
        if (certificateFilePath == null) {
            this.log.info("{}: No service certificate file provided, no service credential will be used.", (Object)name);
            return null;
        }
        String privateKeyPassword = IniConfigUtil.getString(configSection, SERVICE_KEY_PASSWORD_PROP, null);
        this.log.info("{}: service credential certificate: {}", (Object)name, (Object)certificateFilePath);
        this.log.info("{}: service credential private key: {}", (Object)name, (Object)privateKeyFilePath);
        this.log.info("{}: service credential private key password: {}", (Object)name, (Object)(privateKeyPassword == null ? "not set (unencrypted key)" : "set"));
        try {
            PEMCredential credential = new PEMCredential(privateKeyFilePath, certificateFilePath, privateKeyPassword != null ? privateKeyPassword.toCharArray() : null);
            return credential.getKeyManager();
        }
        catch (Exception e) {
            this.log.error("Unable to create service key manager", (Throwable)e);
            throw new ConfigurationException("Unable to read service credential information", e);
        }
    }

    protected X509CertChainValidatorExt getX509CertChainValidator(Profile.Section configSection) throws ConfigurationException {
        if (configSection == null) {
            return null;
        }
        String name = configSection.getName();
        String trustStoreDir = IniConfigUtil.getString(configSection, TRUST_INFO_DIR_PROP, null);
        if (trustStoreDir == null) {
            this.log.info("{}: No truststore directory given, no trust manager will be used", (Object)name);
            return null;
        }
        try {
            Files.getFile(trustStoreDir, false, true, true, false);
        }
        catch (IOException e) {
            this.log.error("Unable to read truststore directory " + trustStoreDir, (Throwable)e);
            throw new ConfigurationException(e.getMessage());
        }
        this.log.info("{}: X.509 trust information directory: {}", (Object)name, (Object)trustStoreDir);
        int refreshInterval = this.getTrustMaterialRefreshInterval(configSection) * 60 * 1000;
        this.log.info("{}: X.509 trust information refresh interval: {}ms", (Object)name, (Object)refreshInterval);
        try {
            OpensslCertChainValidator validator = new OpensslCertChainValidator(trustStoreDir);
            validator.setUpdateInterval((long)refreshInterval);
            TrustStoreValidationErrorLogger validationListener = new TrustStoreValidationErrorLogger();
            validator.addValidationListener((ValidationErrorListener)validationListener);
            return validator;
        }
        catch (Exception e) {
            this.log.error("Unable to create X.509 trust store", (Throwable)e);
            throw new ConfigurationException("Unable to create X.509 trust store", e);
        }
    }
}

