/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.config;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class AbstractConfiguration {
    public static final String BINDING_NAME = "org.glite.authz.common.config";
    private X509KeyManager keyManager = null;
    private X509TrustManager trustManager = null;
    private X509CertChainValidatorExt certChainValidator;
    private int maxRequests = 0;
    private int connectionTimeout = 0;
    private int receiveBufferSize = 0;
    private int sendBufferSize = 0;

    protected AbstractConfiguration() {
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public X509CertChainValidatorExt getCertChainValidator() {
        return this.certChainValidator;
    }

    protected final synchronized void setConnectionTimeout(int timeout) {
        if (this.connectionTimeout != 0) {
            throw new IllegalStateException("The connection timeout has already been set, it may not be changed.");
        }
        if (timeout < 1) {
            throw new IllegalArgumentException("Connection timeout may not be less than 1 millisecond");
        }
        this.connectionTimeout = timeout;
    }

    protected final synchronized void setMaxRequests(int max) {
        if (this.maxRequests != 0) {
            throw new IllegalStateException("The maximum number of requests has already been set, it may not be changed.");
        }
        if (max < 1) {
            throw new IllegalArgumentException("Maximum number of requests may not be less than 1");
        }
        this.maxRequests = max;
    }

    protected final synchronized void setReceiveBufferSize(int size) {
        if (this.receiveBufferSize != 0) {
            throw new IllegalStateException("Receive buffer size has already been set, it may not be changed.");
        }
        if (size < 1) {
            throw new IllegalArgumentException("Receive buffer size may not be less than 1 byte in size");
        }
        this.receiveBufferSize = size;
    }

    protected final synchronized void setSendBufferSize(int size) {
        if (this.sendBufferSize != 0) {
            throw new IllegalStateException("Send buffer size has already been set, it may not be changed.");
        }
        if (size < 1) {
            throw new IllegalArgumentException("Response buffer size may not be less than 1 byte in size");
        }
        this.sendBufferSize = size;
    }

    protected final synchronized void setKeyManager(X509KeyManager manager) {
        if (this.keyManager != null) {
            throw new IllegalStateException("The service key manager has already been set, it may not be changed.");
        }
        this.keyManager = manager;
    }

    protected final synchronized void setTrustManager(X509TrustManager manager) {
        if (this.trustManager != null) {
            throw new IllegalStateException("The service trust manager has already been set, it may not be changed.");
        }
        this.trustManager = manager;
    }

    protected final synchronized void setCertChainValidator(X509CertChainValidatorExt validator) {
        if (this.certChainValidator != null) {
            throw new IllegalStateException("The service cert chain validator has already been set, it may not be changed.");
        }
        this.certChainValidator = validator;
    }
}

