/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.herasaf.xacml.core.types.IPAddress;
import org.herasaf.xacml.core.types.PortRange;

public class IPv6Address
extends IPAddress {
    private static final String REGEX = "\\[[\\.:0-9A-Fa-f]+\\](/\\[[\\.:0-9A-Fa-f]+\\])?(:[\\d\\-]+)?";
    private InetAddress ip;
    private InetAddress mask;
    private PortRange portRange;

    public IPv6Address(String value) {
        if (!value.matches(REGEX)) {
            throw new IllegalArgumentException(String.valueOf(value) + " is not a valid IP Address");
        }
        try {
            boolean hasRange;
            int slashPosition = value.indexOf("/");
            int bracketPosition = value.lastIndexOf("]");
            int colonPosition = value.lastIndexOf(":");
            boolean bl = hasRange = colonPosition - bracketPosition == 1;
            if (slashPosition != -1 && hasRange) {
                this.ip = Inet6Address.getByName(value.substring(1, slashPosition - 1));
                this.mask = Inet6Address.getByName(value.substring(slashPosition + 2, colonPosition - 1));
                this.portRange = new PortRange(value.substring(colonPosition + 1, value.length()));
            } else if (slashPosition != -1) {
                this.ip = Inet6Address.getByName(value.substring(1, slashPosition - 1));
                this.mask = Inet6Address.getByName(value.substring(slashPosition + 2, value.length() - 1));
            } else if (hasRange) {
                this.ip = Inet6Address.getByName(value.substring(1, colonPosition - 1));
                this.portRange = new PortRange(value.substring(colonPosition + 1, value.length()));
            } else {
                this.ip = Inet6Address.getByName(value.substring(1, value.length() - 1));
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (this.ip instanceof Inet4Address) {
            builder.append("0:0:0:0:0:ffff:");
        }
        builder.append(this.ip.getHostAddress());
        builder.append("]");
        if (this.mask != null) {
            builder.append("/[");
            if (this.mask instanceof Inet4Address) {
                builder.append("0:0:0:0:0:ffff:");
            }
            builder.append(this.mask.getHostAddress());
            builder.append("]");
        }
        if (this.portRange != null) {
            builder.append(":");
            builder.append(this.portRange.toString());
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

