/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

public class HexBinary {
    private byte[] value;

    public HexBinary(String value) {
        if (value.length() % 2 != 0) {
            throw new IllegalArgumentException("A HexBinary string must have even length.");
        }
        byte[] result = new byte[value.length() / 2];
        int j = 0;
        int i = 0;
        while (i < value.length()) {
            byte b;
            char c = value.charAt(i++);
            char d = value.charAt(i++);
            if (c >= '0' && c <= '9') {
                b = (byte)(c - 48 << 4);
            } else if (c >= 'A' && c <= 'F') {
                b = (byte)(c - 65 + 10 << 4);
            } else if (c >= 'a' && c <= 'f') {
                b = (byte)(c - 97 + 10 << 4);
            } else {
                throw new IllegalArgumentException("Invalid hex digit: " + c);
            }
            if (d >= '0' && d <= '9') {
                b = (byte)(b + (byte)(d - 48));
            } else if (d >= 'A' && d <= 'F') {
                b = (byte)(b + (byte)(d - 65 + 10));
            } else if (d >= 'a' && d <= 'f') {
                b = (byte)(b + (byte)(d - 97 + 10));
            } else {
                throw new IllegalArgumentException("Invalid hex digit: " + d);
            }
            result[j++] = b;
        }
        this.value = result;
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HexBinary) {
            if (this.value.length != ((HexBinary)obj).getValue().length) {
                return false;
            }
            int i = 0;
            while (i < this.value.length) {
                if (this.value[i] != ((HexBinary)obj).getValue()[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashValue = 0;
        int i = 0;
        while (i < this.value.length) {
            hashValue += this.value[i] * (this.value.length ^ this.value.length - i - 1);
            ++i;
        }
        return hashValue;
    }
}

