/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.herasaf.xacml.core.types.DayTimeDuration;
import org.herasaf.xacml.core.types.YearMonthDuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTime
implements Comparable<DateTime> {
    private static final String MATCH_PATTERN = "\\S*-\\S*:\\S*";
    private XMLGregorianCalendar xmlCalendar;

    public DateTime(String lexicalRepresentation) {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            if (!lexicalRepresentation.matches(MATCH_PATTERN)) {
                throw new IllegalArgumentException("Only a Date is allowed");
            }
            this.xmlCalendar = factory.newXMLGregorianCalendar(lexicalRepresentation);
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XMLGregorianCalendar getCalendar() {
        return this.xmlCalendar;
    }

    public String toString() {
        return this.xmlCalendar.toXMLFormat();
    }

    @Override
    public int compareTo(DateTime dateTime) {
        return this.xmlCalendar.compare(dateTime.getCalendar());
    }

    public boolean equals(Object obj) {
        return obj instanceof DateTime && this.compareTo((DateTime)obj) == 0;
    }

    public int hashCode() {
        return this.xmlCalendar.hashCode();
    }

    public void add(DayTimeDuration duration) {
        this.xmlCalendar.add(duration.getDuration());
    }

    public void add(YearMonthDuration duration) {
        this.xmlCalendar.add(duration.getDuration());
    }

    public void subtract(DayTimeDuration duration) {
        if (duration.getDuration().toString().charAt(0) == '-') {
            this.xmlCalendar.add(new DayTimeDuration(duration.getDuration().toString().substring(1)).getDuration());
        } else {
            this.xmlCalendar.add(new DayTimeDuration("-" + duration.getDuration().toString()).getDuration());
        }
    }

    public void subtract(YearMonthDuration duration) {
        if (duration.getDuration().toString().charAt(0) == '-') {
            this.xmlCalendar.add(new YearMonthDuration(duration.getDuration().toString().substring(1)).getDuration());
        } else {
            this.xmlCalendar.add(new YearMonthDuration("-" + duration.getDuration().toString()).getDuration());
        }
    }
}

