/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.targetMatcher.impl;

import java.util.List;
import org.herasaf.xacml.core.ProcessingException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.function.Function;
import org.herasaf.xacml.core.policy.MissingAttributeException;
import org.herasaf.xacml.core.policy.impl.ActionType;
import org.herasaf.xacml.core.policy.impl.ActionsType;
import org.herasaf.xacml.core.policy.impl.AttributeDesignatorType;
import org.herasaf.xacml.core.policy.impl.AttributeValueType;
import org.herasaf.xacml.core.policy.impl.EnvironmentType;
import org.herasaf.xacml.core.policy.impl.EnvironmentsType;
import org.herasaf.xacml.core.policy.impl.Match;
import org.herasaf.xacml.core.policy.impl.ResourceType;
import org.herasaf.xacml.core.policy.impl.ResourcesType;
import org.herasaf.xacml.core.policy.impl.SubjectType;
import org.herasaf.xacml.core.policy.impl.SubjectsType;
import org.herasaf.xacml.core.policy.impl.TargetType;
import org.herasaf.xacml.core.targetMatcher.TargetMatcher;
import org.herasaf.xacml.core.targetMatcher.TargetMatchingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetMatcherImpl
implements TargetMatcher {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(TargetMatcherImpl.class);

    @Override
    public TargetMatchingResult match(RequestType request, TargetType target, EvaluationContext evaluationContext) throws SyntaxException, ProcessingException, MissingAttributeException {
        if (target != null) {
            this.logger.debug("Starting subjects match.");
            boolean subjectsMatches = this.subjectsMatch(target.getSubjects(), request, evaluationContext);
            this.logger.debug("Subjects match resulted in: {}", (Object)subjectsMatches);
            if (!subjectsMatches) {
                return TargetMatchingResult.NO_MATCH;
            }
            this.logger.debug("Starting recources match.");
            boolean resourcesMatches = this.resourcesMatch(target.getResources(), request, evaluationContext);
            this.logger.debug("Resources match resulted in: {}", (Object)resourcesMatches);
            if (!resourcesMatches) {
                return TargetMatchingResult.NO_MATCH;
            }
            this.logger.debug("Starting actions match.");
            boolean actionsMatches = this.actionMatch(target.getActions(), request, evaluationContext);
            this.logger.debug("Actions match resulted in: {}", (Object)actionsMatches);
            if (!actionsMatches) {
                return TargetMatchingResult.NO_MATCH;
            }
            this.logger.debug("Starting environments match.");
            boolean environmentsMatches = this.environmentMatch(target.getEnvironments(), request, evaluationContext);
            this.logger.debug("Environments match resulted in: {}", (Object)environmentsMatches);
            if (!environmentsMatches) {
                return TargetMatchingResult.NO_MATCH;
            }
        }
        return TargetMatchingResult.MATCH;
    }

    private boolean subjectsMatch(SubjectsType subjects, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        if (subjects == null) {
            this.logger.debug("No subjects present.");
            return true;
        }
        int i = 0;
        while (i < subjects.getSubjects().size()) {
            SubjectType targetSubject = subjects.getSubjects().get(i);
            this.logger.debug("Starting subject match. (id:{})", (Object)targetSubject.toString());
            boolean matches = this.match(targetSubject.getSubjectMatches(), request, evaluationContext);
            if (matches) {
                this.logger.debug("Subject match resulted in: {}", (Object)matches);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean resourcesMatch(ResourcesType resources, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        if (resources == null) {
            this.logger.debug("No resources present.");
            return true;
        }
        int i = 0;
        while (i < resources.getResources().size()) {
            ResourceType targetResource = resources.getResources().get(i);
            this.logger.debug("Starting resource match. (id:{})", (Object)targetResource.toString());
            boolean matches = this.match(targetResource.getResourceMatches(), request, evaluationContext);
            if (matches) {
                this.logger.debug("Resource match resulted in: {}", (Object)matches);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean actionMatch(ActionsType actions, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        if (actions == null) {
            this.logger.debug("No actions present.");
            return true;
        }
        int i = 0;
        while (i < actions.getActions().size()) {
            ActionType targetAction = actions.getActions().get(i);
            this.logger.debug("Starting action match. (id:{})", (Object)targetAction.toString());
            boolean matches = this.match(targetAction.getActionMatches(), request, evaluationContext);
            if (matches) {
                this.logger.debug("Action match resulted in: {}", (Object)matches);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean environmentMatch(EnvironmentsType environments, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        if (environments == null) {
            this.logger.debug("No environments present.");
            return true;
        }
        int i = 0;
        while (i < environments.getEnvironments().size()) {
            EnvironmentType targetEnvironment = environments.getEnvironments().get(i);
            this.logger.debug("Starting environment match. (id:{})", (Object)targetEnvironment.toString());
            boolean matches = this.match(targetEnvironment.getEnvironmentMatches(), request, evaluationContext);
            if (matches) {
                this.logger.debug("Environment match resulted in: {}", (Object)matches);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean match(List<? extends Match> matches, RequestType request, EvaluationContext evaluationContext) throws ProcessingException, SyntaxException, MissingAttributeException {
        int i = 0;
        while (i < matches.size()) {
            Match match = matches.get(i);
            Function matchFunction = match.getMatchFunction();
            this.logger.debug("Matching with function: {}", (Object)matchFunction.toString());
            AttributeDesignatorType designator = match.getAttributeDesignator();
            List requestAttributeValues = (List)designator.handle(request, evaluationContext);
            if (requestAttributeValues.size() == 0) {
                this.logger.debug("Request did not contain the required attributes.");
                return false;
            }
            boolean matchMatches = false;
            int k = 0;
            while (k < requestAttributeValues.size()) {
                Object requestAttributeValue = requestAttributeValues.get(k);
                AttributeValueType policyAttributeValue = match.getAttributeValue();
                matchMatches = (Boolean)matchFunction.handle(policyAttributeValue.getDataType().convertTo((String)policyAttributeValue.getContent().get(0)), requestAttributeValue);
                this.logger.debug("Match function resulted in {} with policy attribute datatype:{} value:{} and request attribute value:{}", new Object[]{matchMatches, policyAttributeValue.getDataType(), policyAttributeValue.getContent().get(0), requestAttributeValue});
                if (matchMatches) break;
                ++k;
            }
            if (!matchMatches) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

