/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herasaf.xacml.core.PolicyRepositoryException;
import org.herasaf.xacml.core.api.DeploymentModification;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.api.UnorderedPolicyRepository;
import org.herasaf.xacml.core.context.RequestCtx;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.EvaluatableID;
import org.herasaf.xacml.core.policy.impl.IdReferenceType;
import org.herasaf.xacml.core.policy.impl.PolicySetType;
import org.herasaf.xacml.core.policy.impl.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBasedSimplePolicyRepository
implements UnorderedPolicyRepository,
PolicyRetrievalPoint {
    protected Map<EvaluatableID, List<Evaluatable>> individualEvaluatables;
    protected Map<EvaluatableID, List<EvaluatableID>> rootEvaluatableMapping;
    protected List<Evaluatable> rootEvaluatables;
    private final Logger logger = LoggerFactory.getLogger(MapBasedSimplePolicyRepository.class);

    public MapBasedSimplePolicyRepository() {
        this.individualEvaluatables = new HashMap<EvaluatableID, List<Evaluatable>>();
        this.rootEvaluatableMapping = new HashMap<EvaluatableID, List<EvaluatableID>>();
        this.rootEvaluatables = new ArrayList<Evaluatable>();
        this.logger.warn("This policy repository ({}) must not be used in a productive environment.", (Object)this.getClass().getCanonicalName());
    }

    @Override
    public void deploy(Collection<Evaluatable> evaluatables) {
        for (Evaluatable eval : evaluatables) {
            this.deploy(eval);
        }
    }

    protected void checkEvaluatable(Map<EvaluatableID, List<Evaluatable>> newIndividualEvaluatables) {
        if (!this.checkReferenceConsistency(newIndividualEvaluatables)) {
            throw new PolicyRepositoryException("The PolicySet is not consistent.");
        }
        for (EvaluatableID id : newIndividualEvaluatables.keySet()) {
            if (!this.individualEvaluatables.containsKey(id)) continue;
            throw new PolicyRepositoryException("The ID must be unique over all PolicySets and Policies.");
        }
    }

    @Override
    public void deploy(Evaluatable evaluatable) {
        Map<EvaluatableID, List<Evaluatable>> newIndividualEvaluatables = this.splitIntoIndividuals(evaluatable, evaluatable.getId());
        this.checkEvaluatable(newIndividualEvaluatables);
        this.individualEvaluatables.putAll(newIndividualEvaluatables);
        this.rootEvaluatables.add(evaluatable);
    }

    @Override
    public void undeploy(EvaluatableID id) {
        boolean foundAtLeastOneMatchingEvaluatable = false;
        int i = 0;
        while (i < this.rootEvaluatables.size()) {
            Evaluatable eval = this.rootEvaluatables.get(i);
            if (eval.getId().equals(id)) {
                foundAtLeastOneMatchingEvaluatable = true;
                this.rootEvaluatables.remove(eval);
                List<EvaluatableID> ids = this.rootEvaluatableMapping.get(eval.getId());
                for (EvaluatableID evalId : ids) {
                    this.individualEvaluatables.remove(evalId);
                }
                this.rootEvaluatableMapping.remove(eval.getId());
            }
            ++i;
        }
        if (!foundAtLeastOneMatchingEvaluatable) {
            throw new PolicyRepositoryException("No root policy with id: " + id.getId());
        }
    }

    @Override
    public void undeploy(Collection<EvaluatableID> ids) {
        for (EvaluatableID id : ids) {
            this.undeploy(id);
        }
    }

    public void applyDeploymentModifications(List<DeploymentModification> deploymentInstructions) {
        String msg = "The MapBasedSimplePolicyRepository does not support the application of Diffs";
        this.logger.error(msg);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public List<Evaluatable> getDeployment() {
        return this.rootEvaluatables;
    }

    public List<Evaluatable> getDeployment(Date dateTime) {
        String msg = "The MapBasedSimplePolicyRepository does not persist previous deployments.";
        this.logger.error(msg);
        throw new UnsupportedOperationException(msg);
    }

    public Map<Date, List<Evaluatable>> getDeployments() {
        String msg = "The MapBasedSimplePolicyRepository does not persist previous deployments.";
        this.logger.error(msg);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public Evaluatable getEvaluatable(EvaluatableID id) {
        List<Evaluatable> evals = this.individualEvaluatables.get(id);
        if (evals != null) {
            for (Evaluatable eval : evals) {
                if (!(eval instanceof PolicyType) && !(eval instanceof PolicySetType)) continue;
                return eval;
            }
        }
        throw new PolicyRepositoryException("No Evaluatable with ID " + id.getId() + " found.");
    }

    @Override
    public List<Evaluatable> getEvaluatables(RequestCtx requestCtx) {
        return this.rootEvaluatables;
    }

    private Map<EvaluatableID, List<Evaluatable>> splitIntoIndividuals(Map<EvaluatableID, List<Evaluatable>> initialMap, Evaluatable evaluatable, EvaluatableID rootId) {
        Map<EvaluatableID, List<Evaluatable>> individualEvaluatables = initialMap == null ? new HashMap<EvaluatableID, List<Evaluatable>>() : initialMap;
        if (individualEvaluatables.containsKey(evaluatable.getId())) {
            individualEvaluatables.get(evaluatable.getId()).add(evaluatable);
        } else {
            ArrayList<Evaluatable> value = new ArrayList<Evaluatable>();
            value.add(evaluatable);
            individualEvaluatables.put(evaluatable.getId(), value);
            this.addRootMapping(evaluatable.getId(), rootId);
        }
        if (evaluatable instanceof PolicySetType) {
            for (Evaluatable eval : ((PolicySetType)evaluatable).getUnorderedEvaluatables(null)) {
                individualEvaluatables.putAll(this.splitIntoIndividuals(individualEvaluatables, eval, rootId));
            }
        }
        return individualEvaluatables;
    }

    protected Map<EvaluatableID, List<Evaluatable>> splitIntoIndividuals(Evaluatable evaluatable, EvaluatableID rootId) {
        return this.splitIntoIndividuals(null, evaluatable, rootId);
    }

    private void addRootMapping(EvaluatableID id, EvaluatableID rootId) {
        if (this.rootEvaluatableMapping.containsKey(rootId)) {
            this.rootEvaluatableMapping.get(rootId).add(id);
        } else {
            ArrayList<EvaluatableID> value = new ArrayList<EvaluatableID>();
            value.add(id);
            this.rootEvaluatableMapping.put(rootId, value);
        }
    }

    private boolean checkReferenceConsistency(Map<EvaluatableID, List<Evaluatable>> individualEvaluatables) {
        for (List<Evaluatable> evals : individualEvaluatables.values()) {
            if (evals.size() == 1) {
                if (!(evals.get(0) instanceof IdReferenceType)) continue;
                this.logger.error("This implementation of the PolicyRepository interface does not support remote references. Further a local reference must be within the same PolicySet.");
                return false;
            }
            boolean anEvaluatableFound = false;
            for (Evaluatable eval : evals) {
                if (!(eval instanceof IdReferenceType) && anEvaluatableFound) {
                    this.logger.error("The ID must be unique over all PolicySets and Policies.");
                    return false;
                }
                if (eval instanceof IdReferenceType) continue;
                anEvaluatableFound = true;
            }
        }
        return true;
    }
}

