/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.specialMatchFunctions;

import javax.security.auth.x500.X500Principal;
import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class X500NameMatchFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:x500Name-match";
    private static final long serialVersionUID = 1L;

    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length != 2) {
                throw new FunctionProcessingException("Invalid number of parameters");
            }
            String[] expectedName = ((X500Principal)args[0]).getName("RFC2253").split(",");
            String[] comparedName = ((X500Principal)args[1]).getName("RFC2253").split(",");
            int i = 0;
            while (i < expectedName.length) {
                boolean found = false;
                int k = 0;
                while (k < comparedName.length) {
                    if (expectedName[i].trim().equals(comparedName[k].trim())) {
                        found = true;
                    }
                    ++k;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException("The arguments were of the wrong datatype.");
        }
        catch (FunctionProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    public String getFunctionId() {
        return ID;
    }
}

