/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.logicalFunctions;

import java.math.BigInteger;
import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class NOFFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:n-of";
    private static final long serialVersionUID = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object handle(Object ... args) throws FunctionProcessingException {
        int handledArrayFields = 1;
        try {
            if (args.length < 1) {
                throw new FunctionProcessingException("Invalid number of parameters");
            }
            Integer minOccurence = (int)((BigInteger)args[0]).longValue();
            if (minOccurence > args.length - 1) {
                throw new FunctionProcessingException("n-of function has less arguments then required to evaluate to true.");
            }
            do {
                if (handledArrayFields > args.length) {
                    return false;
                }
                if (minOccurence <= 0) {
                    return true;
                }
                if (!((Boolean)args[handledArrayFields]).booleanValue()) continue;
                minOccurence = minOccurence - 1;
            } while (minOccurence <= args.length - ++handledArrayFields);
            return false;
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException(e);
        }
        catch (FunctionProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    public String getFunctionId() {
        return ID;
    }
}

