/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.arithmeticFunctions;

import java.math.BigInteger;
import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class IntegerAddFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:integer-add";
    private static final long serialVersionUID = 1L;

    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length < 2) {
                throw new FunctionProcessingException("Invalid number of parameters.");
            }
            BigInteger[] integers = new BigInteger[args.length];
            int i = 0;
            while (i < args.length) {
                integers[i] = (BigInteger)args[i];
                ++i;
            }
            BigInteger result = new BigInteger("0");
            BigInteger[] bigIntegerArray = integers;
            int n = integers.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger i2 = bigIntegerArray[n2];
                result = result.add(i2);
                ++n2;
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException("The arguments were of the wrong datatype.");
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    public String getFunctionId() {
        return ID;
    }
}

