/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.function.impl.arithmeticFunctions;

import org.herasaf.xacml.core.function.AbstractFunction;
import org.herasaf.xacml.core.function.FunctionProcessingException;

public class DoubleAddFunction
extends AbstractFunction {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:function:double-add";
    private static final long serialVersionUID = 1L;

    public Object handle(Object ... args) throws FunctionProcessingException {
        try {
            if (args.length < 2) {
                throw new FunctionProcessingException("Invalid number of parameters.");
            }
            Double[] integers = new Double[args.length];
            int i = 0;
            while (i < args.length) {
                integers[i] = (Double)args[i];
                ++i;
            }
            Double result = new Double("0");
            Double[] doubleArray = integers;
            int n = integers.length;
            int n2 = 0;
            while (n2 < n) {
                Double i2 = doubleArray[n2];
                result = result + i2;
                ++n2;
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new FunctionProcessingException("The arguments were of the wrong datatype.");
        }
        catch (Exception e) {
            throw new FunctionProcessingException(e);
        }
    }

    public String getFunctionId() {
        return ID;
    }
}

