/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.converter;

import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.combiningAlgorithm.rule.RuleCombiningAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URNToRuleCombiningAlgorithmConverter
extends XmlAdapter<String, RuleCombiningAlgorithm> {
    private final Logger logger = LoggerFactory.getLogger(URNToRuleCombiningAlgorithmConverter.class);
    private static Map<String, RuleCombiningAlgorithm> combiningAlgorithms;

    public static void setCombiningAlgorithms(Map<String, RuleCombiningAlgorithm> algorithms) {
        combiningAlgorithms = algorithms;
    }

    public String marshal(RuleCombiningAlgorithm combAlg) {
        String combAlgString;
        try {
            combAlgString = combAlg.toString();
        }
        catch (NullPointerException e) {
            this.logger.error("Argument combAlg must not be null: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return combAlgString;
    }

    public RuleCombiningAlgorithm unmarshal(String combAlgId) {
        RuleCombiningAlgorithm combAlg;
        try {
            combAlg = combiningAlgorithms.get(combAlgId);
        }
        catch (NullPointerException e) {
            this.logger.error("URNToRuleCombiningAlgorithmConverter not properly initialized.");
            throw new NotInitializedException(e);
        }
        if (combAlg != null) {
            return combAlg;
        }
        throw new IllegalArgumentException("Combining Algorithm " + combAlgId + " unknown.");
    }
}

