/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.converter;

import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URNToFunctionConverter
extends XmlAdapter<String, Function> {
    private final Logger logger = LoggerFactory.getLogger(URNToFunctionConverter.class);
    private static Map<String, Function> functions;

    public static void setFunctions(Map<String, Function> functions) {
        URNToFunctionConverter.functions = functions;
    }

    public String marshal(Function function) {
        String functionString;
        try {
            functionString = function.toString();
        }
        catch (NullPointerException e) {
            this.logger.error("Argument function must not be null: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return functionString;
    }

    public Function unmarshal(String functionId) {
        Function func;
        try {
            func = functions.get(functionId);
        }
        catch (NullPointerException e) {
            this.logger.error("URNToFunctionConverter not properly initialized.");
            throw new NotInitializedException(e);
        }
        if (func != null) {
            return func;
        }
        throw new IllegalArgumentException("Function " + functionId + " unknown.");
    }
}

