/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context.impl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.herasaf.xacml.core.context.impl.ActionType;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.EnvironmentType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.context.impl.SubjectType;
import org.herasaf.xacml.core.dataTypeAttribute.impl.DateDataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.DateTimeDataTypeAttribute;
import org.herasaf.xacml.core.dataTypeAttribute.impl.TimeDataTypeAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlType(name="RequestType", propOrder={"subjects", "resources", "action", "environment"})
public class RequestType
implements Serializable {
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String DATE_PATTERN = "yyyy-MM-ddZ";
    private static final String TIME_PATTERN = "HH:mm:ss.SSSZ";
    private static final String CURRENT_DATETIME_DATATYPEID = "urn:oasis:names:tc:xacml:1.0:environment:current-dateTime";
    private static final String CURRENT_DATE_DATATYPEID = "urn:oasis:names:tc:xacml:1.0:environment:current-date";
    private static final String CURRENT_TIME_DATATYPEID = "urn:oasis:names:tc:xacml:1.0:environment:current-time";
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Subject", required=true)
    private List<SubjectType> subjects;
    @XmlElement(name="Resource", required=true)
    private List<ResourceType> resources;
    @XmlElement(name="Action", required=true)
    private ActionType action;
    @XmlElement(name="Environment", required=true)
    private EnvironmentType environment;

    public void beforeMarshal(Marshaller marshaller) {
        if (!this.envContainsAttributeId(CURRENT_TIME_DATATYPEID)) {
            this.environment.getAttributes().add(this.createCurrentTime());
        }
        if (!this.envContainsAttributeId(CURRENT_DATE_DATATYPEID)) {
            this.environment.getAttributes().add(this.createCurrentDate());
        }
        if (!this.envContainsAttributeId(CURRENT_DATETIME_DATATYPEID)) {
            this.environment.getAttributes().add(this.createCurrentDateTime());
        }
    }

    private AttributeType createCurrentTime() {
        AttributeType currentTimeAttr = new AttributeType();
        currentTimeAttr.setAttributeId(CURRENT_TIME_DATATYPEID);
        currentTimeAttr.setDataType(new TimeDataTypeAttribute());
        currentTimeAttr.getAttributeValues().add(this.createDateTime(TIME_PATTERN));
        return currentTimeAttr;
    }

    private AttributeType createCurrentDate() {
        AttributeType currentDateAttr = new AttributeType();
        currentDateAttr.setAttributeId(CURRENT_DATE_DATATYPEID);
        currentDateAttr.setDataType(new DateDataTypeAttribute());
        currentDateAttr.getAttributeValues().add(this.createDateTime(DATE_PATTERN));
        return currentDateAttr;
    }

    private AttributeType createCurrentDateTime() {
        AttributeType currentDateTimeAttr = new AttributeType();
        currentDateTimeAttr.setAttributeId(CURRENT_DATETIME_DATATYPEID);
        currentDateTimeAttr.setDataType(new DateTimeDataTypeAttribute());
        currentDateTimeAttr.getAttributeValues().add(this.createDateTime(DATE_TIME_PATTERN));
        return currentDateTimeAttr;
    }

    private AttributeValueType createDateTime(String pattern) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        AttributeValueType attrValue = new AttributeValueType();
        String value = sdf.format(cal.getTime());
        value = String.valueOf(value.substring(0, value.length() - 2)) + ":" + value.substring(value.length() - 2, value.length());
        attrValue.getContent().add(value);
        return attrValue;
    }

    private boolean envContainsAttributeId(String id) {
        for (AttributeType attr : this.environment.getAttributes()) {
            if (!attr.getAttributeId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public List<SubjectType> getSubjects() {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectType>();
        }
        return this.subjects;
    }

    public List<ResourceType> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<ResourceType>();
        }
        return this.resources;
    }

    public ActionType getAction() {
        return this.action;
    }

    public void setAction(ActionType value) {
        this.action = value;
    }

    public EnvironmentType getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentType value) {
        this.environment = value;
    }
}

