/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context;

import java.util.Comparator;
import org.herasaf.xacml.core.context.StatusCode;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.simplePDP.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCodeComparator
implements Comparator<StatusCode> {
    private final Logger logger = LoggerFactory.getLogger(StatusCodeComparator.class);

    @Override
    public int compare(StatusCode sc1, StatusCode sc2) {
        if (sc1 instanceof XACMLDefaultStatusCode && sc2 instanceof XACMLDefaultStatusCode) {
            switch ((XACMLDefaultStatusCode)sc1) {
                case OK: {
                    switch ((XACMLDefaultStatusCode)sc2) {
                        case OK: {
                            return 0;
                        }
                        case MISSING_ATTRIBUTE: {
                            return -1;
                        }
                        case PROCESSING_ERROR: {
                            return -1;
                        }
                        case SYNTAX_ERROR: {
                            return -1;
                        }
                    }
                    break;
                }
                case MISSING_ATTRIBUTE: {
                    switch ((XACMLDefaultStatusCode)sc2) {
                        case OK: {
                            return 1;
                        }
                        case MISSING_ATTRIBUTE: {
                            return 0;
                        }
                        case PROCESSING_ERROR: {
                            return 1;
                        }
                        case SYNTAX_ERROR: {
                            return -1;
                        }
                    }
                    break;
                }
                case PROCESSING_ERROR: {
                    switch ((XACMLDefaultStatusCode)sc2) {
                        case OK: {
                            return 1;
                        }
                        case MISSING_ATTRIBUTE: {
                            return -1;
                        }
                        case PROCESSING_ERROR: {
                            return 0;
                        }
                        case SYNTAX_ERROR: {
                            return -1;
                        }
                    }
                    break;
                }
                case SYNTAX_ERROR: {
                    switch ((XACMLDefaultStatusCode)sc2) {
                        case OK: {
                            return 1;
                        }
                        case MISSING_ATTRIBUTE: {
                            return 1;
                        }
                        case PROCESSING_ERROR: {
                            return 1;
                        }
                        case SYNTAX_ERROR: {
                            return 0;
                        }
                    }
                }
            }
            InitializationException ie = new InitializationException("Illegal state of status codes.");
            this.logger.error(ie.getMessage());
            throw ie;
        }
        InitializationException ie = new InitializationException("Non-default status codes in use. Use a custom status code comparator.");
        this.logger.error(ie.getMessage());
        throw ie;
    }
}

