/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.WritingException;
import org.herasaf.xacml.core.context.impl.ObjectFactory;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.utils.DefaultValidationEventHandler;
import org.herasaf.xacml.core.utils.JAXBMarshallerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class RequestCtx
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(RequestCtx.class);
    private RequestType request;
    private static JAXBContext CONTEXT;
    private static JAXBMarshallerConfiguration CONFIGURATION;
    private static final ObjectFactory OBJECT_FACTORY;

    static {
        OBJECT_FACTORY = new ObjectFactory();
    }

    public static void setJAXBContext(JAXBContext context) {
        CONTEXT = context;
    }

    public static void setJAXBMarshallerConfiguration(JAXBMarshallerConfiguration configuration) {
        CONFIGURATION = configuration;
    }

    public RequestCtx(RequestType request) {
        this.request = request;
    }

    private Marshaller createMarshaller() throws JAXBException, PropertyException {
        Marshaller marshaller = CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)CONFIGURATION.isFormattedOutput());
        marshaller.setProperty("jaxb.fragment", (Object)CONFIGURATION.isFragment());
        if (CONFIGURATION.isWriteSchemaLocation()) {
            if ("".equals(CONFIGURATION)) {
                this.logger.error("SchemaLocation not initialized.");
                throw new NotInitializedException("SchemaLocation not initialized.");
            }
            marshaller.setProperty("jaxb.schemaLocation", (Object)CONFIGURATION.getSchemaLocationAsString());
        }
        if (CONFIGURATION.isValidateWriting()) {
            if (CONFIGURATION.getSchema() == null) {
                this.logger.error("Schema not initialized.");
                throw new NotInitializedException("Schema not initialized");
            }
            marshaller.setSchema(CONFIGURATION.getSchema());
        }
        if (CONFIGURATION.getValidationEventHandler() == null) {
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        } else {
            marshaller.setEventHandler(CONFIGURATION.getValidationEventHandler());
        }
        return marshaller;
    }

    public RequestType getRequest() {
        return this.request;
    }

    public void marshal(ContentHandler ch) throws WritingException {
        try {
            this.createMarshaller().marshal(OBJECT_FACTORY.createRequest(this.request), ch);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the content handler.", e);
            this.logger.error(we.getMessage());
            throw we;
        }
    }

    public void marshal(File file) throws WritingException {
        try {
            this.createMarshaller().marshal(OBJECT_FACTORY.createRequest(this.request), file);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the file.", e);
            this.logger.error(we.getMessage());
            throw we;
        }
    }

    public void marshal(Result result) throws WritingException {
        try {
            this.createMarshaller().marshal(OBJECT_FACTORY.createRequest(this.request), result);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the result.", e);
            this.logger.error(we.getMessage());
            throw we;
        }
    }

    public void marshal(OutputStream out) throws WritingException {
        try {
            this.createMarshaller().marshal(OBJECT_FACTORY.createRequest(this.request), out);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the output stream.", e);
            this.logger.error(we.getMessage());
            throw we;
        }
    }

    public void marshal(Writer writer) throws WritingException {
        try {
            this.createMarshaller().marshal(OBJECT_FACTORY.createRequest(this.request), writer);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the writer.", e);
            this.logger.error(we.getMessage());
            throw we;
        }
    }

    public void marshal(Node node) throws WritingException {
        try {
            this.createMarshaller().marshal(OBJECT_FACTORY.createRequest(this.request), node);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the node.", e);
            this.logger.error(we.getMessage());
            throw we;
        }
    }

    public void marshal(XMLStreamWriter xmlStreamWriter) throws WritingException {
        try {
            this.createMarshaller().marshal(OBJECT_FACTORY.createRequest(this.request), xmlStreamWriter);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the xml stream writer.", e);
            this.logger.error(we.getMessage());
            throw we;
        }
    }

    public void marshal(XMLEventWriter xmlEventWriter) throws WritingException {
        try {
            this.createMarshaller().marshal(OBJECT_FACTORY.createRequest(this.request), xmlEventWriter);
        }
        catch (JAXBException e) {
            WritingException we = new WritingException("Unable to write to the xml event writer.", e);
            this.logger.error(we.getMessage());
            throw we;
        }
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.marshal(os);
        }
        catch (WritingException e) {
            this.logger.warn("Could not marshal RequestCtx to OutputStream.", (Throwable)e);
            return null;
        }
        return ((Object)os).toString();
    }
}

