/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.context;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herasaf.xacml.core.api.PIP;
import org.herasaf.xacml.core.context.StatusCode;
import org.herasaf.xacml.core.context.StatusCodeComparator;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.policy.impl.EffectType;
import org.herasaf.xacml.core.policy.impl.ObjectFactory;
import org.herasaf.xacml.core.policy.impl.ObligationType;
import org.herasaf.xacml.core.policy.impl.ObligationsType;
import org.herasaf.xacml.core.policy.impl.Variable;
import org.herasaf.xacml.core.targetMatcher.TargetMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationContext {
    private PIP pip;
    private StatusCode statusCode;
    private List<MissingAttributeDetailType> missingAttributes;
    private boolean targetMatched;
    private Map<String, Variable> variableDefinitions;
    private ObligationsType obligations;
    private static ObjectFactory objectFactory = new ObjectFactory();
    private boolean respectAbandonedEvaluatables;
    private TargetMatcher targetMatcher;
    private Map<Object, Object> customValues;
    private Comparator<StatusCode> statusCodeComparator;

    public EvaluationContext(TargetMatcher targetMatcher, StatusCodeComparator statusCodeComparator) {
        this(targetMatcher, null, false, statusCodeComparator);
    }

    public EvaluationContext(TargetMatcher targetMatcher, PIP pip, StatusCodeComparator statusCodeComparator) {
        this(targetMatcher, pip, false, statusCodeComparator);
    }

    public EvaluationContext(TargetMatcher targetMatcher, boolean respectAbandonedEvaluatables, StatusCodeComparator statusCodeComparator) {
        this(targetMatcher, null, respectAbandonedEvaluatables, statusCodeComparator);
    }

    public EvaluationContext(TargetMatcher targetMatcher, Comparator<StatusCode> statusCodeComparator) {
        this(targetMatcher, null, false, statusCodeComparator);
    }

    public EvaluationContext(TargetMatcher targetMatcher, PIP pip, boolean respectAbandonedEvaluatables, Comparator<StatusCode> statusCodeComparator) {
        this.pip = pip;
        this.respectAbandonedEvaluatables = respectAbandonedEvaluatables;
        this.targetMatcher = targetMatcher;
        this.statusCode = XACMLDefaultStatusCode.OK;
        this.missingAttributes = new ArrayList<MissingAttributeDetailType>();
        this.targetMatched = true;
        this.obligations = objectFactory.createObligationsType();
        this.customValues = new HashMap<Object, Object>();
        this.statusCodeComparator = statusCodeComparator;
    }

    public void put(Object key, Object value) {
        this.customValues.put(key, value);
    }

    public Object get(Object key) {
        return this.customValues.get(key);
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void updateStatusCode(StatusCode code) {
        if (this.statusCodeComparator.compare(code, this.getStatusCode()) > 0) {
            this.statusCode = code;
        }
    }

    public void updateStatusCode(List<StatusCode> statusCodes) {
        for (StatusCode code : statusCodes) {
            this.updateStatusCode(code);
        }
    }

    public void resetStatus() {
        this.statusCode = XACMLDefaultStatusCode.OK;
        this.missingAttributes.clear();
        this.targetMatched = true;
    }

    public List<MissingAttributeDetailType> getMissingAttributes() {
        return this.missingAttributes;
    }

    public void setMissingAttributes(List<MissingAttributeDetailType> missingAttributes) {
        this.missingAttributes = missingAttributes;
    }

    public boolean isTargetMatched() {
        return this.targetMatched;
    }

    public void setTargetMatched(boolean targetMatched) {
        this.targetMatched = targetMatched;
    }

    public void addMissingAttributes(MissingAttributeDetailType missingAttribute) {
        this.missingAttributes.add(missingAttribute);
    }

    public Map<String, Variable> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    public void setVariableDefinitions(Map<String, Variable> variableDefinitions) {
        this.variableDefinitions = variableDefinitions;
    }

    public PIP getPIP() {
        return this.pip;
    }

    public boolean isRespectAbandonedEvaluatables() {
        return this.respectAbandonedEvaluatables;
    }

    public void addObligations(List<ObligationType> obligations, EffectType effect) {
        ArrayList<ObligationType> obls = new ArrayList<ObligationType>();
        int i = 0;
        while (i < obligations.size()) {
            ObligationType obl = obligations.get(i);
            if (obl.getFulfillOn().equals((Object)effect)) {
                obls.add(obl);
            }
            ++i;
        }
        this.obligations.getObligations().addAll(obls);
    }

    public void clearObligations() {
        this.obligations.getObligations().clear();
    }

    public ObligationsType getObligations() {
        return this.obligations;
    }

    public TargetMatcher getTargetMatcher() {
        return this.targetMatcher;
    }

    public String toString() {
        StringBuilder stringValue = new StringBuilder("EvaluationContext[");
        stringValue.append("pip=");
        stringValue.append(this.pip);
        stringValue.append(", statusCode=");
        stringValue.append(this.statusCode);
        stringValue.append(", missingAttributes=");
        stringValue.append(this.missingAttributes);
        stringValue.append(", targetMatched=");
        stringValue.append(this.targetMatched);
        stringValue.append(", variableDefinitions=");
        stringValue.append(this.variableDefinitions);
        stringValue.append(", obligations=");
        stringValue.append(this.obligations);
        stringValue.append("]");
        return stringValue.toString();
    }
}

