/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm.rule.impl;

import java.util.ArrayList;
import java.util.List;
import org.herasaf.xacml.core.combiningAlgorithm.rule.RuleUnorderedCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.StatusCode;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.impl.EffectType;
import org.herasaf.xacml.core.policy.impl.RuleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulePermitOverridesAlgorithm
extends RuleUnorderedCombiningAlgorithm {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides";
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(RulePermitOverridesAlgorithm.class);

    @Override
    public String getCombiningAlgorithmId() {
        return ID;
    }

    @Override
    public DecisionType evaluateRuleList(RequestType request, List<RuleType> rules, EvaluationContext evaluationContext) {
        if (rules == null) {
            this.logger.error("the rules list was null. This is an illegal state.");
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            return DecisionType.INDETERMINATE;
        }
        ArrayList<MissingAttributeDetailType> missingAttributes = new ArrayList<MissingAttributeDetailType>();
        ArrayList<StatusCode> statusCodes = new ArrayList<StatusCode>();
        boolean atLeastOneError = false;
        boolean potentialPermit = false;
        boolean atLeastOneDeny = false;
        int i = 0;
        while (i < rules.size()) {
            RuleType rule = rules.get(i);
            if (rule == null) {
                this.logger.error("The list of rules must not contain any null values.");
                evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
                return DecisionType.INDETERMINATE;
            }
            evaluationContext.resetStatus();
            if (this.logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:ruleid", (String)rule.getRuleId());
                this.logger.debug("Starting evaluation of: {}", (Object)rule.getRuleId());
            }
            DecisionType decision = this.evaluateRule(request, rule, evaluationContext);
            if (this.logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:ruleid", (String)rule.getRuleId());
                this.logger.debug("Evaluation of {} was: {}", (Object)rule.getRuleId(), (Object)decision.toString());
                MDC.remove((String)"org:herasaf:xacml:evaluation:ruleid");
            }
            switch (decision) {
                case DENY: {
                    atLeastOneDeny = true;
                    break;
                }
                case INDETERMINATE: {
                    missingAttributes.addAll(evaluationContext.getMissingAttributes());
                    statusCodes.add(evaluationContext.getStatusCode());
                    atLeastOneError = true;
                    if (rule.getEffect() != EffectType.PERMIT) break;
                    potentialPermit = true;
                    break;
                }
                case PERMIT: {
                    return decision;
                }
            }
            ++i;
        }
        if (potentialPermit) {
            evaluationContext.resetStatus();
            evaluationContext.setMissingAttributes(missingAttributes);
            evaluationContext.updateStatusCode(statusCodes);
            return DecisionType.INDETERMINATE;
        }
        if (atLeastOneDeny) {
            evaluationContext.resetStatus();
            evaluationContext.setMissingAttributes(missingAttributes);
            evaluationContext.updateStatusCode(statusCodes);
            return DecisionType.DENY;
        }
        if (atLeastOneError) {
            evaluationContext.resetStatus();
            evaluationContext.setMissingAttributes(missingAttributes);
            evaluationContext.updateStatusCode(statusCodes);
            return DecisionType.INDETERMINATE;
        }
        return DecisionType.NOT_APPLICABLE;
    }
}

