/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm.policy.impl;

import java.util.ArrayList;
import java.util.List;
import org.herasaf.xacml.core.combiningAlgorithm.CombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyOrderedCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.StatusCode;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.impl.EffectType;
import org.herasaf.xacml.core.policy.impl.ObligationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyOrderedPermitOverridesAlgorithm
extends PolicyOrderedCombiningAlgorithm {
    public static final String ID = "urn:oasis:names:tc:xacml:1.1:policy-combining-algorithm:ordered-permit-overrides";
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(PolicyOrderedPermitOverridesAlgorithm.class);

    @Override
    public DecisionType evaluateEvaluatableList(RequestType request, List<Evaluatable> possiblePolicies, EvaluationContext evaluationContext) {
        if (possiblePolicies == null) {
            this.logger.error("The possiblePolicies list was null. This is an illegal state.");
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            return DecisionType.INDETERMINATE;
        }
        boolean atLeastOneError = false;
        boolean atLeastOneDeny = false;
        boolean atLeastOnePermit = false;
        ArrayList<MissingAttributeDetailType> missingAttributes = new ArrayList<MissingAttributeDetailType>();
        ArrayList<StatusCode> statusCodes = new ArrayList<StatusCode>();
        ArrayList<ObligationType> obligationsOfApplicableEvals = new ArrayList<ObligationType>();
        int i = 0;
        while (i < possiblePolicies.size()) {
            DecisionType decision;
            CombiningAlgorithm combiningAlg;
            Evaluatable eval = possiblePolicies.get(i);
            if (eval == null) {
                this.logger.error("The list of possible policies must not contain any null values.");
                evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
                return DecisionType.INDETERMINATE;
            }
            if (atLeastOnePermit && evaluationContext.isRespectAbandonedEvaluatables() && !eval.hasObligations()) break;
            evaluationContext.resetStatus();
            if (this.logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:evaluatableid", (String)eval.getId().getId());
                this.logger.debug("Starting evaluation of: {}", (Object)eval.getId().getId());
            }
            if ((combiningAlg = eval.getCombiningAlg()) == null) {
                this.logger.error("Unable to locate combining algorithm for policy {}", (Object)eval.getId());
                evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
                decision = DecisionType.INDETERMINATE;
            } else {
                decision = combiningAlg.evaluate(request, eval, evaluationContext);
            }
            if (this.logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:evaluatableid", (String)eval.getId().getId());
                this.logger.debug("Evaluation of {} was: {}", (Object)eval.getId().getId(), (Object)decision.toString());
                MDC.remove((String)"org:herasaf:xacml:evaluation:evaluatableid");
            }
            if (decision == DecisionType.PERMIT || decision == DecisionType.DENY) {
                obligationsOfApplicableEvals.addAll(eval.getContainedObligations(EffectType.fromValue(decision.toString())));
                obligationsOfApplicableEvals.addAll(evaluationContext.getObligations().getObligations());
            }
            switch (decision) {
                case PERMIT: {
                    if (!evaluationContext.isRespectAbandonedEvaluatables()) {
                        evaluationContext.clearObligations();
                        evaluationContext.addObligations(obligationsOfApplicableEvals, EffectType.PERMIT);
                        evaluationContext.resetStatus();
                        return DecisionType.PERMIT;
                    }
                    atLeastOnePermit = true;
                    break;
                }
                case DENY: {
                    missingAttributes.addAll(evaluationContext.getMissingAttributes());
                    statusCodes.add(evaluationContext.getStatusCode());
                    atLeastOneDeny = true;
                    break;
                }
                case INDETERMINATE: {
                    missingAttributes.addAll(evaluationContext.getMissingAttributes());
                    statusCodes.add(evaluationContext.getStatusCode());
                    atLeastOneError = true;
                    break;
                }
            }
            evaluationContext.clearObligations();
            ++i;
        }
        if (atLeastOnePermit) {
            evaluationContext.resetStatus();
            evaluationContext.addObligations(obligationsOfApplicableEvals, EffectType.PERMIT);
            return DecisionType.PERMIT;
        }
        if (atLeastOneDeny) {
            evaluationContext.addObligations(obligationsOfApplicableEvals, EffectType.DENY);
            evaluationContext.setMissingAttributes(missingAttributes);
            evaluationContext.resetStatus();
            return DecisionType.DENY;
        }
        if (atLeastOneError) {
            evaluationContext.setMissingAttributes(missingAttributes);
            evaluationContext.updateStatusCode(statusCodes);
            return DecisionType.INDETERMINATE;
        }
        evaluationContext.clearObligations();
        return DecisionType.NOT_APPLICABLE;
    }

    @Override
    public String getCombiningAlgorithmId() {
        return ID;
    }
}

