/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm;

import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.ProcessingException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.combiningAlgorithm.CombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.MissingAttributeException;
import org.herasaf.xacml.core.policy.impl.TargetType;
import org.herasaf.xacml.core.targetMatcher.TargetMatchingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCombiningAlgorithm
implements CombiningAlgorithm {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(AbstractCombiningAlgorithm.class);

    protected TargetMatchingResult matchTarget(RequestType request, TargetType target, EvaluationContext evaluationContext) {
        TargetMatchingResult targetMatchDecision = TargetMatchingResult.NO_MATCH;
        try {
            this.logger.debug("Starting target match.");
            targetMatchDecision = evaluationContext.getTargetMatcher().match(request, target, evaluationContext);
            switch (targetMatchDecision) {
                case MATCH: 
                case INDETERMINATE: {
                    break;
                }
                case NO_MATCH: {
                    evaluationContext.setTargetMatched(false);
                }
            }
        }
        catch (NullPointerException e) {
            this.logger.error("TargetMatcher not initialized.", (Throwable)e);
            throw new NotInitializedException(e);
        }
        catch (SyntaxException e) {
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            evaluationContext.setTargetMatched(false);
            this.logger.debug("Syntax error occurred.");
            targetMatchDecision = TargetMatchingResult.INDETERMINATE;
        }
        catch (ProcessingException e) {
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.PROCESSING_ERROR);
            evaluationContext.setTargetMatched(false);
            this.logger.debug("Processing error occurred.");
            targetMatchDecision = TargetMatchingResult.INDETERMINATE;
        }
        catch (MissingAttributeException e) {
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.MISSING_ATTRIBUTE);
            evaluationContext.addMissingAttributes(e.getMissingAttribute());
            evaluationContext.setTargetMatched(false);
            this.logger.debug("Missing attribute error occurred.");
            targetMatchDecision = TargetMatchingResult.INDETERMINATE;
        }
        this.logger.debug("Target match resulted in: {}", (Object)targetMatchDecision);
        return targetMatchDecision;
    }

    public String toString() {
        return this.getCombiningAlgorithmId();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.getCombiningAlgorithmId().hashCode();
    }

    public abstract String getCombiningAlgorithmId();
}

