/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.util.Strings;
import org.herasaf.xacml.core.WritingException;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.PolicyMarshaller;
import org.herasaf.xacml.core.policy.impl.ObligationType;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.Statement;
import org.opensaml.xacml.XACMLObjectBuilder;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusCodeType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionQueryType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class XACMLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XACMLUtil.class);
    private static SAMLObjectBuilder<XACMLAuthzDecisionStatementType> authzStatementBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20);
    private static XACMLObjectBuilder<ResponseType> xacmlResponseBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResponseType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<DecisionType> decisionBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(DecisionType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ResultType> resultBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ResultType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<ObligationsType> obligationsBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(ObligationsType.SCHEMA_TYPE_NAME);
    private static XACMLObjectBuilder<org.opensaml.xacml.policy.ObligationType> obligationBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(org.opensaml.xacml.policy.ObligationType.SCHEMA_TYPE_NAME);
    private static XACMLObjectBuilder<StatusCodeType> statusCodeBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(StatusCodeType.DEFAULT_ELEMENT_NAME);
    private static XACMLObjectBuilder<StatusType> statusBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(StatusType.DEFAULT_ELEMENT_NAME);

    public static void bootstrap() {
    }

    public static XACMLAuthzDecisionStatementType buildAuthZDecisionStatement(RequestType authzRequest, ResponseType authzResponse) {
        XACMLAuthzDecisionStatementType authzStatement = (XACMLAuthzDecisionStatementType)authzStatementBuilder.buildObject(Statement.DEFAULT_ELEMENT_NAME, XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20);
        authzStatement.setRequest(authzRequest);
        authzStatement.setResponse(authzResponse);
        return authzStatement;
    }

    public static RequestType buildRequest(XACMLAuthzDecisionQueryType authzRequest) {
        if (!authzRequest.isReturnContext().booleanValue()) {
            return null;
        }
        Element requestElem = authzRequest.getRequest().getDOM();
        if (requestElem == null) {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)authzRequest);
            try {
                requestElem = marshaller.marshall((XMLObject)authzRequest);
            }
            catch (MarshallingException e) {
                LOG.error("Unable to marshall XACML request context", (Throwable)e);
                return null;
            }
        }
        Element requestElemClone = (Element)requestElem.cloneNode(true);
        Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(requestElem);
        try {
            RequestType xacmlRequest = (RequestType)unmarshaller.unmarshall(requestElemClone);
            return xacmlRequest;
        }
        catch (UnmarshallingException e) {
            LOG.error("Error unmarshalling clone of XACML request context element", (Throwable)e);
            return null;
        }
    }

    public static ResponseType buildResponse(ResultType result) {
        ResponseType response = (ResponseType)xacmlResponseBuilder.buildObject();
        response.setResult(result);
        return response;
    }

    public static ResultType buildResult(String resourceId, DecisionType.DECISION decision, List<org.opensaml.xacml.policy.ObligationType> obligationCollection, StatusType status) {
        DecisionType xacmlDecision = (DecisionType)decisionBuilder.buildObject();
        xacmlDecision.setDecision(decision);
        ResultType result = (ResultType)resultBuilder.buildObject();
        result.setResourceId(Strings.safeTrimOrNullString((String)resourceId));
        result.setDecision(xacmlDecision);
        result.setStatus(status);
        if (obligationCollection != null && !obligationCollection.isEmpty()) {
            ObligationsType obligations = (ObligationsType)obligationsBuilder.buildObject();
            obligations.getObligations().addAll(obligationCollection);
            result.setObligations(obligations);
        }
        return result;
    }

    public static org.opensaml.xacml.policy.ObligationType buildObligation(ObligationType herasObligation) {
        if (herasObligation == null) {
            return null;
        }
        if (herasObligation.getAttributeAssignments() != null && !herasObligation.getAttributeAssignments().isEmpty()) {
            LOG.error("Obligations with attribute assignments are nor currently supported");
            return null;
        }
        org.opensaml.xacml.policy.ObligationType obligation = (org.opensaml.xacml.policy.ObligationType)obligationBuilder.buildObject();
        obligation.setObligationId(herasObligation.getObligationId());
        switch (herasObligation.getFulfillOn()) {
            case DENY: {
                obligation.setFulfillOn(EffectType.Deny);
                break;
            }
            case PERMIT: {
                obligation.setFulfillOn(EffectType.Permit);
            }
        }
        return obligation;
    }

    public static StatusType buildStatus(String statusCodeValue) {
        StatusCodeType statusCode = (StatusCodeType)statusCodeBuilder.buildObject();
        statusCode.setValue(statusCodeValue);
        StatusType status = (StatusType)statusBuilder.buildObject();
        status.setStatusCode(statusCode);
        return status;
    }

    public static String marshall(Evaluatable jaxbElement) {
        if (jaxbElement == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            PolicyMarshaller.marshal((Evaluatable)jaxbElement, (Writer)writer);
            return writer.toString();
        }
        catch (WritingException e) {
            LOG.error("Unable to log policy to be used for authorization decision", (Throwable)e);
            return null;
        }
    }
}

