/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.util;

import java.security.NoSuchAlgorithmException;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.util.Strings;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;

@ThreadSafe
public class SAMLUtil {
    private static IdentifierGenerator idgen;
    private static SAMLObjectBuilder<Response> samlResponseBuilder;
    private static SAMLObjectBuilder<Assertion> assertionBuilder;
    private static SAMLObjectBuilder<Issuer> issuerBuilder;
    private static SAMLObjectBuilder<StatusCode> statusCodeBuilder;
    private static SAMLObjectBuilder<StatusMessage> statusMessageBuilder;
    private static SAMLObjectBuilder<Status> statusBuilder;

    public static void bootstrap() {
    }

    public static Response buildSAMLResponse(String inResponseTo, DateTime issueInstant, Assertion assertion, Status status) {
        Response samlResponse = (Response)samlResponseBuilder.buildObject();
        samlResponse.setID(idgen.generateIdentifier());
        samlResponse.setInResponseTo(inResponseTo);
        samlResponse.setIssueInstant(issueInstant);
        samlResponse.getAssertions().add(assertion);
        samlResponse.setStatus(status);
        return samlResponse;
    }

    public static Assertion buildAssertion(String issuerEntityId, DateTime issueInstant, XACMLAuthzDecisionStatementType authzDecisionStatement) {
        Assertion assertion = (Assertion)assertionBuilder.buildObject();
        assertion.setID(idgen.generateIdentifier());
        assertion.setIssueInstant(issueInstant);
        assertion.setIssuer(SAMLUtil.buildIssuer(issuerEntityId));
        assertion.getStatements().add(authzDecisionStatement);
        return assertion;
    }

    public static Issuer buildIssuer(String entityId) {
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        issuer.setValue(entityId);
        return issuer;
    }

    public static Status buildStatus(String statusCodeValue, String statusMessageValue) {
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue(statusCodeValue);
        StatusMessage statusMessage = null;
        if (!Strings.isEmpty((String)statusMessageValue)) {
            statusMessage = (StatusMessage)statusMessageBuilder.buildObject();
            statusMessage.setMessage(statusMessageValue);
        }
        Status status = (Status)statusBuilder.buildObject();
        status.setStatusCode(statusCode);
        status.setStatusMessage(statusMessage);
        return status;
    }

    static {
        samlResponseBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Response.DEFAULT_ELEMENT_NAME);
        assertionBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        issuerBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        statusCodeBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        statusMessageBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(StatusMessage.DEFAULT_ELEMENT_NAME);
        statusBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Status.DEFAULT_ELEMENT_NAME);
        try {
            idgen = new SecureRandomIdentifierGenerator();
            idgen.generateIdentifier();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

