/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.util;

import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.util.Strings;
import org.joda.time.DateTime;
import org.opensaml.xacml.ctx.DecisionType;

@ThreadSafe
public class AuditLogEntry {
    private long requestTime = new DateTime().toDateTimeISO().getMillis();
    private String requesterId;
    private String requestId;
    private String policyId;
    private String policyVersion;
    private DecisionType.DECISION policyDecision;
    private String responseId;

    public AuditLogEntry(String requester, String request, String policy, String version, DecisionType.DECISION decision, String response) {
        this.requesterId = Strings.safeTrimOrNullString((String)requester);
        this.requestId = Strings.safeTrimOrNullString((String)request);
        this.policyId = Strings.safeTrimOrNullString((String)policy);
        this.policyVersion = Strings.safeTrimOrNullString((String)version);
        this.policyDecision = decision;
        this.responseId = Strings.safeTrimOrNullString((String)response);
    }

    public DecisionType.DECISION getPolicyDecision() {
        return this.policyDecision;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getPolicyVersion() {
        return this.policyVersion;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String getResponseId() {
        return this.responseId;
    }

    public String toString() {
        StringBuilder entryString = new StringBuilder();
        entryString.append(this.getRequestTime());
        entryString.append("|");
        entryString.append(this.getRequesterId());
        entryString.append("|");
        entryString.append(this.getRequestId());
        entryString.append("|");
        entryString.append(this.getPolicyId());
        entryString.append("|");
        entryString.append(this.getPolicyVersion());
        entryString.append("|");
        entryString.append(this.getPolicyDecision());
        entryString.append("|");
        entryString.append(this.getResponseId());
        entryString.append("|");
        return entryString.toString();
    }
}

