/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.server;

import java.io.PrintWriter;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.ServiceMetrics;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pdp.server.Version;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

@ThreadSafe
public class PDPMetrics
extends ServiceMetrics {
    private long policyLoadTimeMillis;
    private String policyId;
    private String policyVersion;

    public PDPMetrics() {
        super(Version.getServiceName(), Version.getServiceVersion());
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public long getPolicyLoadInstant() {
        return this.policyLoadTimeMillis;
    }

    public String getPolicyVersion() {
        return this.policyVersion;
    }

    public synchronized void updatePolicyInformation(String id, String version) {
        this.policyId = Strings.safeTrimOrNullString((String)id);
        this.policyLoadTimeMillis = System.currentTimeMillis();
        this.policyVersion = Strings.safeTrimOrNullString((String)version);
    }

    public void printServiceMetrics(PrintWriter writer) {
        super.printServiceMetrics(writer);
        DateTime policyLoadTime = null;
        if (this.policyLoadTimeMillis > 0L) {
            policyLoadTime = new DateTime(this.policyLoadTimeMillis).withChronology((Chronology)ISOChronology.getInstanceUTC());
        }
        writer.println("PolicyLoadTime: " + policyLoadTime);
        writer.println("PolicyLoadTimeMillis: " + this.policyLoadTimeMillis);
        writer.println("CurrentPolicy: " + this.policyId);
        writer.println("CurrentPolicyVersion: " + this.policyVersion);
    }
}

