/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.server;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.AbstractQueue;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.http.AbstractAdminCommand;
import org.glite.authz.common.http.JettyAdminService;
import org.glite.authz.common.http.JettyRunThread;
import org.glite.authz.common.http.JettyServerShutdownTask;
import org.glite.authz.common.http.JettySslSelectChannelConnector;
import org.glite.authz.common.http.ServiceMetricsServlet;
import org.glite.authz.common.http.ShutdownTask;
import org.glite.authz.common.http.StatusCommand;
import org.glite.authz.common.http.SystemExitTask;
import org.glite.authz.common.http.TimerShutdownTask;
import org.glite.authz.common.logging.AccessLoggingFilter;
import org.glite.authz.common.logging.LoggingReloadTask;
import org.glite.authz.common.util.Files;
import org.glite.authz.pdp.config.PDPConfiguration;
import org.glite.authz.pdp.config.PDPIniConfigurationParser;
import org.glite.authz.pdp.pip.PolicyInformationPoint;
import org.glite.authz.pdp.policy.PolicyRepository;
import org.glite.authz.pdp.server.AuthorizationRequestServlet;
import org.glite.authz.pdp.server.HerasAFBootstrap;
import org.glite.authz.pdp.server.ReloadPolicyCommand;
import org.glite.authz.pdp.server.Version;
import org.glite.authz.pdp.util.SAMLUtil;
import org.glite.authz.pdp.util.XACMLUtil;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.ThreadPool;
import org.opensaml.DefaultBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDPDaemon {
    public static final String PDP_HOME_PROP = "org.glite.authz.pdp.home";
    public static final String PDP_CONFDIR_PROP = "org.glite.authz.pdp.confdir";
    public static final String PDP_LOGDIR_PROP = "org.glite.authz.pdp.logdir";
    public static final String PDP_GRACEFUL_PROP = "org.glite.authz.pdp.server.graceful";
    public static int DEFAULT_ADMIN_PORT = 8153;
    public static String DEFAULT_ADMIN_HOST = "localhost";
    public static int DEFAULT_SERVICE_PORT = 8152;
    public static final int DEFAULT_LOGGING_CONFIG_REFRESH_PERIOD = 300000;
    private static final Logger LOG = LoggerFactory.getLogger(PDPDaemon.class);

    private PDPDaemon() {
    }

    public static void main(String[] args) throws Exception {
        String confDir;
        if (args.length < 1 || args.length > 1) {
            PDPDaemon.errorAndExit("Missing configuration file argument", null);
        }
        if ((confDir = System.getProperty(PDP_CONFDIR_PROP)) == null) {
            PDPDaemon.errorAndExit("System property org.glite.authz.pdp.confdir is not set", null);
        }
        Timer backgroundTaskTimer = new Timer(true);
        String loggingConfigFilePath = confDir + "/logging.xml";
        PDPDaemon.initializeLogging(loggingConfigFilePath, backgroundTaskTimer);
        Security.addProvider((Provider)new BouncyCastleProvider());
        DefaultBootstrap.bootstrap();
        HerasAFBootstrap.bootstap();
        SAMLUtil.bootstrap();
        XACMLUtil.bootstrap();
        PDPConfiguration daemonConfig = PDPDaemon.parseConfiguration(args[0]);
        PolicyRepository policyRepository = PolicyRepository.instance(daemonConfig, backgroundTaskTimer);
        List<PolicyInformationPoint> pips = daemonConfig.getPolicyInformationPoints();
        if (pips != null && !pips.isEmpty()) {
            for (PolicyInformationPoint pip : daemonConfig.getPolicyInformationPoints()) {
                if (pip == null) continue;
                LOG.debug("Starting PIP {}", (Object)pip.getId());
                pip.start();
            }
        }
        Server authzService = PDPDaemon.createDaemonService(daemonConfig, backgroundTaskTimer);
        JettyRunThread pdpDaemonServiceThread = new JettyRunThread(authzService);
        pdpDaemonServiceThread.setName("PDP Service");
        pdpDaemonServiceThread.start();
        JettyAdminService adminService = PDPDaemon.createAdminService(daemonConfig, backgroundTaskTimer, policyRepository, authzService);
        adminService.start();
        LOG.info(Version.getServiceIdentifier() + " started");
    }

    private static Server createDaemonService(PDPConfiguration daemonConfig, Timer taskTimer) {
        Server httpServer = new Server();
        httpServer.setSendServerVersion(false);
        httpServer.setSendDateHeader(false);
        if (System.getProperty(PDP_GRACEFUL_PROP) != null) {
            LOG.info("Graceful shutdown enabled: org.glite.authz.pdp.server.graceful");
            httpServer.setGracefulShutdown(1000);
        }
        httpServer.setStopAtShutdown(true);
        AbstractQueue requestQueue = daemonConfig.getMaxRequestQueueSize() < 1 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(daemonConfig.getMaxRequestQueueSize());
        org.mortbay.thread.concurrent.ThreadPool threadPool = new org.mortbay.thread.concurrent.ThreadPool(5, daemonConfig.getMaxRequests(), 1L, TimeUnit.SECONDS, requestQueue);
        httpServer.setThreadPool((ThreadPool)threadPool);
        Connector connector = PDPDaemon.createServiceConnector(daemonConfig);
        httpServer.setConnectors(new Connector[]{connector});
        Context servletContext = new Context((HandlerContainer)httpServer, "/", false, false);
        servletContext.setDisplayName("PDP Daemon");
        servletContext.setAttribute("org.glite.authz.common.config", (Object)daemonConfig);
        servletContext.setAttribute("org.glite.authz.pdp.server.timer", (Object)taskTimer);
        FilterHolder accessLoggingFilter = new FilterHolder((Filter)new AccessLoggingFilter());
        servletContext.addFilter(accessLoggingFilter, "/*", 1);
        ServletHolder daemonRequestServlet = new ServletHolder((Servlet)new AuthorizationRequestServlet());
        daemonRequestServlet.setName("PDP Servlet");
        servletContext.addServlet(daemonRequestServlet, "/authz");
        ServletHolder statusRequestServlet = new ServletHolder((Servlet)new ServiceMetricsServlet(daemonConfig.getServiceMetrics()));
        statusRequestServlet.setName("Status Servlet");
        servletContext.addServlet(statusRequestServlet, "/status");
        return httpServer;
    }

    private static JettyAdminService createAdminService(PDPConfiguration daemonConfig, Timer backgroundTaskTimer, PolicyRepository policyRepository, Server daemonService) {
        int adminPort;
        String adminHost = daemonConfig.getAdminHost();
        if (adminHost == null) {
            adminHost = DEFAULT_ADMIN_HOST;
        }
        if ((adminPort = daemonConfig.getAdminPort()) < 1) {
            adminPort = DEFAULT_ADMIN_PORT;
        }
        JettyAdminService adminService = new JettyAdminService(adminHost, adminPort, daemonConfig.getAdminPassword());
        adminService.registerAdminCommand((AbstractAdminCommand)new StatusCommand(daemonConfig.getServiceMetrics()));
        adminService.registerAdminCommand((AbstractAdminCommand)new ReloadPolicyCommand(policyRepository));
        adminService.registerShutdownTask((ShutdownTask)new SystemExitTask(60000L));
        adminService.registerShutdownTask((ShutdownTask)new TimerShutdownTask(backgroundTaskTimer));
        adminService.registerShutdownTask((ShutdownTask)new JettyServerShutdownTask(daemonService));
        return adminService;
    }

    private static Connector createServiceConnector(PDPConfiguration daemonConfig) {
        SelectChannelConnector connector;
        if (!daemonConfig.isSslEnabled()) {
            connector = new SelectChannelConnector();
        } else {
            if (daemonConfig.getKeyManager() == null) {
                LOG.error("Service port was meant to be SSL enabled but no service key/certificate was specified in the configuration file");
            }
            if (daemonConfig.getTrustManager() == null) {
                LOG.error("Service port was meant to be SSL enabled but no trust information directory was specified in the configuration file");
            }
            connector = new JettySslSelectChannelConnector(daemonConfig.getKeyManager(), daemonConfig.getTrustManager());
        }
        connector.setHost(daemonConfig.getHostname());
        if (daemonConfig.getPort() == 0) {
            connector.setPort(DEFAULT_SERVICE_PORT);
        } else {
            connector.setPort(daemonConfig.getPort());
        }
        connector.setMaxIdleTime(daemonConfig.getConnectionTimeout());
        connector.setRequestBufferSize(daemonConfig.getReceiveBufferSize());
        connector.setResponseBufferSize(daemonConfig.getSendBufferSize());
        return connector;
    }

    private static PDPConfiguration parseConfiguration(String configFilePath) {
        File configFile = null;
        try {
            configFile = Files.getReadableFile((String)configFilePath);
        }
        catch (IOException e) {
            PDPDaemon.errorAndExit(e.getMessage(), null);
        }
        try {
            PDPIniConfigurationParser configParser = new PDPIniConfigurationParser();
            return (PDPConfiguration)configParser.parse(new FileReader(configFile));
        }
        catch (IOException e) {
            PDPDaemon.errorAndExit("Unable to read configuration file " + configFilePath, e);
        }
        catch (ConfigurationException e) {
            PDPDaemon.errorAndExit("Error parsing configuration file " + configFilePath, (Exception)((Object)e));
        }
        return null;
    }

    private static void errorAndExit(String errorMessage, Exception e) {
        System.err.println(errorMessage);
        if (e != null) {
            System.err.println("This error was caused by the exception:");
            e.printStackTrace(System.err);
        }
        System.out.flush();
        System.exit(1);
    }

    private static void initializeLogging(String loggingConfigFilePath, Timer reloadTasks) {
        LoggingReloadTask reloadTask = null;
        try {
            reloadTask = new LoggingReloadTask(loggingConfigFilePath);
        }
        catch (IOException e) {
            PDPDaemon.errorAndExit("Invalid logging configuration file: " + loggingConfigFilePath, e);
        }
        int refreshPeriod = 300000;
        reloadTask.run();
        reloadTasks.scheduleAtFixedRate((TimerTask)reloadTask, refreshPeriod, (long)refreshPeriod);
    }
}

