/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.AuthorizationServiceException;
import org.glite.authz.common.http.BaseHttpServlet;
import org.glite.authz.pdp.config.PDPConfiguration;
import org.glite.authz.pdp.obligation.ObligationService;
import org.glite.authz.pdp.pip.PolicyInformationPoint;
import org.glite.authz.pdp.policy.PolicyRepository;
import org.glite.authz.pdp.util.AuditLogEntry;
import org.glite.authz.pdp.util.SAMLUtil;
import org.glite.authz.pdp.util.XACMLUtil;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.RequestCtx;
import org.herasaf.xacml.core.context.RequestCtxFactory;
import org.herasaf.xacml.core.context.StatusCodeComparator;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.impl.PolicySetType;
import org.herasaf.xacml.core.targetMatcher.TargetMatcher;
import org.herasaf.xacml.core.targetMatcher.impl.TargetMatcherImpl;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.saml1.binding.encoding.HTTPSOAP11Encoder;
import org.opensaml.saml2.binding.decoding.HTTPSOAP11Decoder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.soap11.Fault;
import org.opensaml.ws.soap.soap11.FaultCode;
import org.opensaml.ws.soap.soap11.FaultString;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionQueryType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class AuthorizationRequestServlet
extends BaseHttpServlet {
    public static final String TIMER_ATTRIB = "org.glite.authz.pdp.server.timer";
    private static final long serialVersionUID = -4398772758458846951L;
    private final Logger log = LoggerFactory.getLogger(AuthorizationRequestServlet.class);
    private final Logger auditLog = LoggerFactory.getLogger((String)"org.glite.authz.audit");
    private final Logger protocolLog = LoggerFactory.getLogger((String)"org.glite.authz.message.protocol");
    private final Logger policyLog = LoggerFactory.getLogger((String)"org.glite.authz.message.policy");
    private PDPConfiguration pdpConfig;
    private Timer taskTimer;
    private SecurityPolicyResolver messageSecurityPolicyResolver;
    private HTTPSOAP11Decoder messageDecoder;
    private HTTPSOAP11Encoder messageEncoder;
    private SOAPMessageEncoder soapMessageEncoder;
    private PolicyRepository policyRepo;
    private ObligationService obligationService;
    private TargetMatcher targetMatcher = new TargetMatcherImpl();
    private StatusCodeComparator statusCodeComparator = new StatusCodeComparator();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.pdpConfig = (PDPConfiguration)((Object)this.getServletContext().getAttribute("org.glite.authz.common.config"));
        if (this.pdpConfig == null) {
            throw new ServletException("Unable to initialize, no configuration available in servlet context");
        }
        this.taskTimer = (Timer)this.getServletContext().getAttribute(TIMER_ATTRIB);
        if (this.taskTimer == null) {
            throw new ServletException("Unable to initialize, no Timer available in servlet context");
        }
        this.messageSecurityPolicyResolver = new StaticSecurityPolicyResolver(this.pdpConfig.getAuthzDecisionQuerySecurityPolicy());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.setMaxPoolSize(this.pdpConfig.getMaxRequests());
        this.messageDecoder = new HTTPSOAP11Decoder((ParserPool)parserPool);
        this.messageEncoder = new HTTPSOAP11Encoder();
        this.soapMessageEncoder = new SOAPMessageEncoder();
        this.policyRepo = PolicyRepository.instance(this.pdpConfig, this.taskTimer);
    }

    protected void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        AuthzRequestMessageContext messageContext = new AuthzRequestMessageContext();
        try {
            this.decodeMessage(messageContext, httpRequest, httpResponse);
            this.setPolicy(messageContext);
            this.applyPolicyInformationPoints(messageContext);
            this.evaluateAuthorizationPolicy(messageContext);
            this.applyObligationHandlers(messageContext);
        }
        catch (MessageDecodingException e) {
            this.pdpConfig.getServiceMetrics().incrementTotalServiceRequestErrors();
            if (this.log.isDebugEnabled()) {
                this.log.error("Error decoding the SOAP request", (Throwable)e);
            } else {
                this.log.error("Error decoding the SOAP request", (Object)e.getMessage());
            }
            Envelope soapMessage = this.buildSOAPFault((MessageContext)messageContext, e);
            this.encodeSOAPMessage((MessageContext)messageContext, soapMessage);
            return;
        }
        catch (AuthorizationServiceException e) {
            this.pdpConfig.getServiceMetrics().incrementTotalServiceRequestErrors();
            this.log.error("Error processing authorization request.", (Throwable)e);
            ResultType errorResult = XACMLUtil.buildResult(null, DecisionType.DECISION.Indeterminate, null, XACMLUtil.buildStatus("urn:oasis:names:tc:xacml:1.0:status:processing-error"));
            messageContext.setAuthorizationResult(errorResult);
        }
        Response samlResponse = this.buildSAMLResponse(messageContext);
        this.encodeMessage(messageContext, samlResponse);
    }

    protected String getSupportedMethods() {
        return "POST";
    }

    protected void decodeMessage(AuthzRequestMessageContext messageContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws MessageDecodingException, AuthorizationServiceException {
        messageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(httpRequest));
        messageContext.setOutboundMessageTransport((OutTransport)new HttpServletResponseAdapter(httpResponse, httpRequest.isSecure()));
        messageContext.setSecurityPolicyResolver(this.messageSecurityPolicyResolver);
        try {
            this.log.debug("Decoding incomming message");
            this.messageDecoder.decode((MessageContext)messageContext);
            if (this.protocolLog.isInfoEnabled()) {
                this.protocolLog.info("Incomming SOAP message\n{}", (Object)XMLHelper.prettyPrintXML((Node)messageContext.getInboundMessage().getDOM()));
            }
        }
        catch (SecurityException e) {
            throw new AuthorizationServiceException("Incoming request does not meeting security requirements", (Exception)((Object)e));
        }
    }

    protected void setPolicy(AuthzRequestMessageContext messageContext) throws AuthorizationServiceException {
        PolicySetType policy = this.policyRepo.getPolicy();
        if (policy == null) {
            throw new AuthorizationServiceException("No policy available by which the incomming request may be evaluated");
        }
        if (this.policyLog.isDebugEnabled()) {
            this.policyLog.debug("Evaluating authorization request against policy\n{}", (Object)XACMLUtil.marshall((Evaluatable)policy));
        }
        messageContext.setAuthorizationPolicy(policy);
    }

    protected void applyPolicyInformationPoints(AuthzRequestMessageContext messageContext) throws AuthorizationServiceException {
        List<PolicyInformationPoint> pips = this.pdpConfig.getPolicyInformationPoints();
        if (pips == null || pips.isEmpty()) {
            return;
        }
        for (PolicyInformationPoint pip : pips) {
            this.log.debug("Applying PIP '{}' to request", (Object)pip.getId());
            pip.populateRequest(messageContext);
        }
    }

    protected void evaluateAuthorizationPolicy(AuthzRequestMessageContext messageContext) throws AuthorizationServiceException {
        PolicySetType policy = messageContext.getAuthorizationPolicy();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Evaluating request {} from {} against version {} of authorization policy {}", new Object[]{messageContext.getInboundSAMLMessageId(), messageContext.getInboundMessageIssuer(), policy.getVersion(), policy.getPolicySetId()});
            }
            EvaluationContext evaluationContext = new EvaluationContext(this.targetMatcher, this.statusCodeComparator);
            PolicyCombiningAlgorithm combiningAlgo = policy.getCombiningAlg();
            DecisionType decision = combiningAlgo.evaluate(this.getXacmlRequest(messageContext), (Evaluatable)policy, evaluationContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Evaluation of policy {} version {} resulted in decision {} for request {}", new Object[]{policy.getPolicySetId(), policy.getVersion(), decision.toString(), messageContext.getInboundSAMLMessageId()});
            }
            this.log.debug("Building authorization request result");
            String resourceId = this.extractResourceId((XACMLAuthzDecisionQueryType)messageContext.getInboundSAMLMessage());
            StatusType status = XACMLUtil.buildStatus("urn:oasis:names:tc:xacml:1.0:status:ok");
            ArrayList<ObligationType> obligations = null;
            if (evaluationContext.getObligations() != null && evaluationContext.getObligations().getObligations() != null) {
                obligations = new ArrayList<ObligationType>();
                for (org.herasaf.xacml.core.policy.impl.ObligationType herasObligation : evaluationContext.getObligations().getObligations()) {
                    if (herasObligation == null) continue;
                    this.log.debug("Adding obligation '{}' to authorization response", (Object)herasObligation.getObligationId());
                    obligations.add(XACMLUtil.buildObligation(herasObligation));
                }
            }
            ResultType result = XACMLUtil.buildResult(resourceId, DecisionType.DECISION.valueOf((String)decision.value()), obligations, status);
            messageContext.setAuthorizationResult(result);
        }
        catch (Exception e) {
            this.pdpConfig.getServiceMetrics().incrementTotalServiceRequestErrors();
            this.log.error("Error evaluating policy", (Throwable)e);
            throw new AuthorizationServiceException("Error evaluating policy.");
        }
    }

    protected void applyObligationHandlers(AuthzRequestMessageContext messageContext) throws AuthorizationServiceException {
        if (this.obligationService == null) {
            return;
        }
        ResultType result = messageContext.getAuthorizationResult();
        this.obligationService.processObligations(messageContext, result);
    }

    protected org.herasaf.xacml.core.context.impl.RequestType getXacmlRequest(AuthzRequestMessageContext messageContext) throws AuthorizationServiceException {
        XACMLAuthzDecisionQueryType authzRequest = (XACMLAuthzDecisionQueryType)messageContext.getInboundSAMLMessage();
        Element dom = authzRequest.getRequest().getDOM();
        try {
            RequestCtx requestCtx = RequestCtxFactory.unmarshal((Node)dom);
            return requestCtx.getRequest();
        }
        catch (SyntaxException e) {
            this.log.error("Unable to convert SAML/XACML authorization request into HERASAF request context", (Throwable)e);
            throw new AuthorizationServiceException("Invalid request message.", (Exception)((Object)e));
        }
    }

    protected Response buildSAMLResponse(AuthzRequestMessageContext messageContext) {
        this.log.trace("Building XACML request");
        RequestType request = XACMLUtil.buildRequest((XACMLAuthzDecisionQueryType)messageContext.getInboundSAMLMessage());
        this.log.trace("Building XACML response");
        ResponseType response = XACMLUtil.buildResponse(messageContext.getAuthorizationResult());
        this.log.trace("Building XACML authz statement");
        XACMLAuthzDecisionStatementType authzStatement = XACMLUtil.buildAuthZDecisionStatement(request, response);
        this.log.trace("Building SAML assertion");
        Assertion samlAssertion = SAMLUtil.buildAssertion(this.pdpConfig.getEntityId(), messageContext.getOutboundSAMLMessageIssueInstant(), authzStatement);
        this.log.debug("Building SAML response");
        return SAMLUtil.buildSAMLResponse(messageContext.getInboundSAMLMessageId(), messageContext.getOutboundSAMLMessageIssueInstant(), samlAssertion, SAMLUtil.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null));
    }

    protected Envelope buildSOAPFault(MessageContext messageContext, MessageDecodingException e) {
        this.log.debug("Building SOAP Fault: {}", (Object)e.getMessage());
        HTTPOutTransport outTransport = (HTTPOutTransport)messageContext.getOutboundMessageTransport();
        outTransport.setStatusCode(500);
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SOAPObjectBuilder faultBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Fault.DEFAULT_ELEMENT_NAME);
        Fault fault = (Fault)faultBuilder.buildObject();
        SOAPObjectBuilder faultCodeBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(FaultCode.DEFAULT_ELEMENT_NAME);
        FaultCode faultCode = (FaultCode)faultCodeBuilder.buildObject();
        faultCode.setValue(FaultCode.CLIENT);
        fault.setCode(faultCode);
        SOAPObjectBuilder faultStringBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(FaultString.DEFAULT_ELEMENT_NAME);
        FaultString faultString = (FaultString)faultStringBuilder.buildObject();
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            sb.append(": ").append(cause.getMessage());
        }
        faultString.setValue(sb.toString());
        fault.setMessage(faultString);
        SOAPObjectBuilder envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envBuilder.buildObject();
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(fault);
        envelope.setBody(body);
        return envelope;
    }

    private String extractResourceId(XACMLAuthzDecisionQueryType authzRequest) {
        List resources = authzRequest.getRequest().getResources();
        if (resources != null) {
            for (ResourceType resource : resources) {
                List attributes = resource.getAttributes();
                if (attributes == null) continue;
                for (AttributeType attribute : attributes) {
                    List attributeValues;
                    if (!"urn:oasis:names:tc:xacml:1.0:resource:resource-id".equals(attribute.getAttributeID()) || (attributeValues = attribute.getAttributeValues()) == null || attributeValues.isEmpty()) continue;
                    return ((AttributeValueType)attributeValues.get(0)).getValue();
                }
            }
        }
        return null;
    }

    protected void encodeMessage(AuthzRequestMessageContext messageContext, Response samlResponse) {
        messageContext.setOutboundSAMLMessageIssueInstant(new DateTime());
        messageContext.setOutboundMessageIssuer(this.pdpConfig.getEntityId());
        messageContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        messageContext.setOutboundSAMLMessageId(((Response)messageContext.getOutboundSAMLMessage()).getID());
        this.log.debug("Encoding response");
        try {
            this.messageEncoder.encode((MessageContext)messageContext);
            if (this.protocolLog.isDebugEnabled()) {
                this.protocolLog.debug("SOAP response\n{}", (Object)XMLHelper.prettyPrintXML((Node)messageContext.getOutboundMessage().getDOM()));
            }
            this.pdpConfig.getServiceMetrics().incrementTotalServiceRequests();
            this.writeAuditLogEntry(messageContext);
        }
        catch (MessageEncodingException e) {
            this.log.error("Unable to encoding response.", (Throwable)e);
        }
    }

    protected void encodeSOAPMessage(MessageContext messageContext, Envelope soapMessage) {
        messageContext.setOutboundMessage((XMLObject)soapMessage);
        messageContext.setOutboundMessageIssuer(this.pdpConfig.getEntityId());
        this.log.debug("Encoding SOAP response");
        try {
            this.soapMessageEncoder.encode(messageContext);
            if (this.protocolLog.isDebugEnabled()) {
                this.protocolLog.debug("SOAP response\n{}", (Object)XMLHelper.prettyPrintXML((Node)messageContext.getOutboundMessage().getDOM()));
            }
        }
        catch (MessageEncodingException e) {
            this.log.error("Unable to encode SOAP response.", (Throwable)e);
        }
    }

    protected void writeAuditLogEntry(AuthzRequestMessageContext messageContext) {
        String policyId = "";
        String policyVersion = "";
        if (messageContext.getAuthorizationPolicy() != null) {
            policyId = messageContext.getAuthorizationPolicy().getPolicySetId();
            policyVersion = messageContext.getAuthorizationPolicy().getVersion();
        }
        AuditLogEntry auditEntry = new AuditLogEntry(messageContext.getInboundMessageIssuer(), messageContext.getInboundSAMLMessageId(), policyId, policyVersion, messageContext.getAuthorizationResult().getDecision().getDecision(), messageContext.getOutboundSAMLMessageId());
        this.auditLog.info(auditEntry.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AuthzRequestMessageContext
    extends BasicSAMLMessageContext<XACMLAuthzDecisionQueryType, Response, NameID> {
        private PolicySetType policy;
        private ResultType authorizationResult;

        public PolicySetType getAuthorizationPolicy() {
            return this.policy;
        }

        public void setAuthorizationPolicy(PolicySetType authzPolicy) {
            this.policy = authzPolicy;
        }

        public ResultType getAuthorizationResult() {
            return this.authorizationResult;
        }

        public void setAuthorizationResult(ResultType result) {
            this.authorizationResult = result;
        }
    }

    class SOAPMessageEncoder
    extends org.opensaml.ws.soap.soap11.encoder.http.HTTPSOAP11Encoder {
        SOAPMessageEncoder() {
        }

        protected Envelope buildSOAPEnvelope(MessageContext messageContext) {
            return (Envelope)messageContext.getOutboundMessage();
        }
    }
}

