/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.policy;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.pdp.config.PDPConfiguration;
import org.glite.authz.pdp.policy.PolicyAdministrationPointClient;
import org.glite.authz.pdp.server.PDPMetrics;
import org.glite.authz.pdp.util.XACMLUtil;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.PolicyMarshaller;
import org.opensaml.xacml.policy.PolicySetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class PolicyRepository {
    public static final String DEFAULT_NAME = PolicyRepository.class.getPackage() + "." + PolicyRepository.class.getName();
    private static final HashMap<String, PolicyRepository> REPO_INSTANCES = new HashMap();
    private final Logger log = LoggerFactory.getLogger(PolicyRepository.class);
    private final Logger policyLog = LoggerFactory.getLogger((String)"org.glite.authz.message.policy");
    private String repositoryName;
    private PDPConfiguration daemonConfig;
    private PolicyAdministrationPointClient papClient;
    private Timer updatePolicyTimer;
    private org.herasaf.xacml.core.policy.impl.PolicySetType policySet;

    protected PolicyRepository(PDPConfiguration pdpConfig, Timer refreshTimer) {
        this.daemonConfig = pdpConfig;
        this.papClient = new PolicyAdministrationPointClient(pdpConfig);
        this.updatePolicyTimer = refreshTimer;
        long refreshInterval = pdpConfig.getPolicyRetentionInterval() * 60 * 1000;
        this.updatePolicyTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                PolicyRepository.this.refreshPolicy();
            }
        }, 0L, refreshInterval);
    }

    public static synchronized PolicyRepository instance(PDPConfiguration pdpConfig, Timer backgroundTaskTimer) {
        return PolicyRepository.instance(pdpConfig, backgroundTaskTimer, DEFAULT_NAME, true);
    }

    public static synchronized PolicyRepository instance(PDPConfiguration pdpConfig, Timer backgroundTaskTimer, String name, boolean createRepository) {
        PolicyRepository repo = REPO_INSTANCES.get(name);
        if (repo == null && createRepository) {
            repo = new PolicyRepository(pdpConfig, backgroundTaskTimer);
            REPO_INSTANCES.put(name, repo);
        }
        return repo;
    }

    public String getName() {
        return this.repositoryName;
    }

    public org.herasaf.xacml.core.policy.impl.PolicySetType getPolicy() {
        return this.policySet;
    }

    public void refreshPolicy() {
        try {
            this.log.info("Refreshing authorization policy from remote PAPs");
            PolicySetType policySetOM = this.papClient.retrievePolicySet();
            if (policySetOM != null) {
                this.policySet = (org.herasaf.xacml.core.policy.impl.PolicySetType)PolicyMarshaller.unmarshal((Node)policySetOM.getDOM());
                String policySetId = policySetOM.getPolicySetId();
                String policyVersion = policySetOM.getVersion();
                ((PDPMetrics)this.daemonConfig.getServiceMetrics()).updatePolicyInformation(policySetId, policyVersion);
                this.log.info("Loaded version {} of policy {}", (Object)policyVersion, (Object)policySetId);
                if (this.policyLog.isInfoEnabled()) {
                    this.policyLog.info(XACMLUtil.marshall((Evaluatable)this.policySet));
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error refreshing policy from remote PAP, continuing to use existing policy.", (Throwable)e);
        }
    }
}

