/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.policy;

import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.AuthorizationServiceException;
import org.glite.authz.pdp.config.PDPConfiguration;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.impl.RandomIdentifierGenerator;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.ws.soap.client.BasicSOAPMessageContext;
import org.opensaml.ws.soap.client.SOAPClient;
import org.opensaml.ws.soap.client.SOAPFaultException;
import org.opensaml.ws.soap.client.SOAPMessageContext;
import org.opensaml.ws.soap.client.http.HttpSOAPRequestParameters;
import org.opensaml.ws.soap.common.SOAPException;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xacml.XACMLObjectBuilder;
import org.opensaml.xacml.policy.IdReferenceType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.profile.saml.XACMLPolicyQueryType;
import org.opensaml.xacml.profile.saml.XACMLPolicyStatementType;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class PolicyAdministrationPointClient {
    private Logger log = LoggerFactory.getLogger(PolicyAdministrationPointClient.class);
    private Logger protocolLogger = LoggerFactory.getLogger((String)"org.glite.authz.message.protocol");
    private PDPConfiguration pdpConfig;
    private IdentifierGenerator idGen;
    private SOAPObjectBuilder<Envelope> envelopeBuilder;
    private SOAPObjectBuilder<Body> bodyBuilder;
    private SAMLObjectBuilder<XACMLPolicyQueryType> policyQueryBuilder;
    private SAMLObjectBuilder<Issuer> issuerBuilder;
    private XACMLObjectBuilder<IdReferenceType> idReferenceBuilder;

    public PolicyAdministrationPointClient(PDPConfiguration config) {
        this.pdpConfig = config;
        this.idGen = new RandomIdentifierGenerator();
        this.envelopeBuilder = (SOAPObjectBuilder)Configuration.getBuilderFactory().getBuilder(Envelope.TYPE_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)Configuration.getBuilderFactory().getBuilder(Body.TYPE_NAME);
        this.policyQueryBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(XACMLPolicyQueryType.TYPE_NAME_XACML20);
        this.issuerBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        this.idReferenceBuilder = (XACMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(IdReferenceType.POLICY_SET_ID_REFERENCE_ELEMENT_NAME);
    }

    public PolicySetType retrievePolicySet() throws AuthorizationServiceException {
        SOAPMessageContext messageContext = this.buildMessageContext();
        if (this.protocolLogger.isInfoEnabled()) {
            try {
                Marshaller outboundMessageMarshaller = Configuration.getMarshallerFactory().getMarshaller(messageContext.getOutboundMessage());
                Element outboundMessage = outboundMessageMarshaller.marshall(messageContext.getOutboundMessage());
                this.protocolLogger.info("Outbound XACML policy query request\n{}", (Object)XMLHelper.prettyPrintXML((Node)outboundMessage));
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall outbound policy request", (Throwable)e);
                throw new AuthorizationServiceException("Unable to marshall outbound policy request", (Exception)((Object)e));
            }
        }
        Envelope soapResponse = null;
        SOAPClient soapClient = this.pdpConfig.getSOAPClient();
        for (String papEndpoint : this.pdpConfig.getPAPEndpointss()) {
            try {
                soapClient.send(papEndpoint, messageContext);
                if (messageContext.getInboundMessage() == null) continue;
                soapResponse = (Envelope)messageContext.getInboundMessage();
                break;
            }
            catch (SOAPFaultException e) {
                this.log.warn("Recieved SOAP Fault " + e.getFault().getCode() + " from PAP endpoint: " + papEndpoint, (Throwable)e);
            }
            catch (SOAPException e) {
                this.log.warn("Unable to complete request to PAP endpoint: " + papEndpoint, (Throwable)e);
            }
            catch (SecurityException e) {
                this.log.warn("Poliqy query to PAP endpoint " + papEndpoint + " returned a message that did not meet security requirements", (Throwable)e);
            }
        }
        if (soapResponse != null) {
            if (this.protocolLogger.isInfoEnabled()) {
                this.protocolLogger.info("Inbound XACML policy query response\n{}", (Object)XMLHelper.prettyPrintXML((Node)soapResponse.getDOM()));
            }
            Response samlResponse = (Response)soapResponse.getBody().getOrderedChildren().get(0);
            return this.extractPolicySet(samlResponse);
        }
        return null;
    }

    protected SOAPMessageContext buildMessageContext() {
        Envelope outboundMessage = this.buildPolicyRequest();
        HttpSOAPRequestParameters requestParams = new HttpSOAPRequestParameters("http://www.oasis-open.org/committees/security");
        BasicSOAPMessageContext messageContext = new BasicSOAPMessageContext();
        messageContext.setCommunicationProfileId("urn:mace:switch.ch:doc:xacml-saml:profile:200711:SOAP");
        messageContext.setOutboundMessage((XMLObject)outboundMessage);
        messageContext.setOutboundMessageIssuer(this.pdpConfig.getEntityId());
        messageContext.setSOAPRequestParameters((SOAPClient.SOAPRequestParameters)requestParams);
        return messageContext;
    }

    protected Envelope buildPolicyRequest() {
        Issuer issuer = (Issuer)this.issuerBuilder.buildObject();
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        issuer.setValue(this.pdpConfig.getEntityId());
        IdReferenceType policySetReference = (IdReferenceType)this.idReferenceBuilder.buildObject(IdReferenceType.POLICY_SET_ID_REFERENCE_ELEMENT_NAME);
        policySetReference.setValue(this.pdpConfig.getPolicySetId());
        XACMLPolicyQueryType policyQuery = (XACMLPolicyQueryType)this.policyQueryBuilder.buildObject(XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20, XACMLPolicyQueryType.TYPE_NAME_XACML20);
        policyQuery.setID(this.idGen.generateIdentifier());
        policyQuery.setIssueInstant(new DateTime());
        policyQuery.setIssuer(issuer);
        policyQuery.getPolicySetIdReferences().add(policySetReference);
        Body body = (Body)this.bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(policyQuery);
        Envelope env = (Envelope)this.envelopeBuilder.buildObject();
        env.setBody(body);
        return env;
    }

    protected PolicySetType extractPolicySet(Response samlResponse) {
        List assertions;
        if (samlResponse != null && !(assertions = samlResponse.getAssertions()).isEmpty()) {
            List policyStatements;
            if (assertions.size() > 1) {
                this.log.warn("PAP returned a response with more than one assertion, only the first will be used");
            }
            if (!(policyStatements = ((Assertion)assertions.get(0)).getStatements(XACMLPolicyStatementType.TYPE_NAME_XACML20)).isEmpty()) {
                XACMLPolicyStatementType policyStatement;
                List policySets;
                if (policyStatements.size() > 1) {
                    this.log.warn("PAP returned more than one policy statement, only the first will be used");
                }
                if ((policySets = (policyStatement = (XACMLPolicyStatementType)policyStatements.get(0)).getPolicySets()) != null && policySets.size() > 1) {
                    this.log.warn("PAP return more than one policy set, only the first will be used");
                }
                if (policySets.size() > 0) {
                    return (PolicySetType)policySets.get(0);
                }
            }
        }
        return null;
    }
}

