/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.pip;

import java.util.List;
import java.util.StringTokenizer;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.AbstractIniConfigurationParser;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.util.LazyList;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pdp.pip.IniPIPConfigurationParser;
import org.glite.authz.pdp.pip.PolicyInformationPoint;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniPIPConfigurationParserHelper {
    public static final String PIP_PROP = "pips";
    private static final Logger LOG = LoggerFactory.getLogger(IniPIPConfigurationParserHelper.class);

    public static List<PolicyInformationPoint> processPolicyInformationPoints(Ini iniFile, Profile.Section configSection, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        LazyList pips = new LazyList();
        if (configSection.containsKey((Object)PIP_PROP)) {
            StringTokenizer pipNames = new StringTokenizer((String)configSection.get((Object)PIP_PROP), " ");
            while (pipNames.hasMoreTokens()) {
                String pipName = Strings.safeTrimOrNullString((String)pipNames.nextToken());
                if (pipName == null) continue;
                if (!iniFile.containsKey((Object)pipName)) {
                    String errorMsg = "INI configuration file does not contain a configuration section for policy information point " + pipName;
                    LOG.error(errorMsg);
                    throw new ConfigurationException(errorMsg);
                }
                pips.add(IniPIPConfigurationParserHelper.buildPolicyInformationPoint((Profile.Section)iniFile.get((Object)pipName), configBuilder));
                LOG.debug("loadded policy information point: {}", (Object)pipName);
            }
        }
        return pips;
    }

    private static PolicyInformationPoint buildPolicyInformationPoint(Profile.Section pipConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        LOG.info("Loading Policy Information Point {}", (Object)pipConfig.getName());
        String parserClassName = IniConfigUtil.getString((Profile.Section)pipConfig, (String)"parserClass");
        try {
            Class<?> parserClass = AbstractIniConfigurationParser.class.getClassLoader().loadClass(parserClassName);
            IniPIPConfigurationParser parser = (IniPIPConfigurationParser)parserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return parser.parse(pipConfig, configBuilder);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to configure PIP " + pipConfig.getName() + ". The following error was reported: " + e.getMessage(), e);
        }
    }
}

