/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.obligation;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.pdp.obligation.AbstractObligationHandler;
import org.glite.authz.pdp.obligation.ObligationProcessingException;
import org.glite.authz.pdp.server.AuthorizationRequestServlet;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ObligationService {
    private final Logger log = LoggerFactory.getLogger(ObligationService.class);
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private Set<AbstractObligationHandler> obligationHandlers = new TreeSet<AbstractObligationHandler>(new ObligationHandlerComparator());

    public Set<AbstractObligationHandler> getObligationHandlers() {
        return Collections.unmodifiableSet(this.obligationHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObligationhandler(AbstractObligationHandler handler) {
        if (handler == null) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.add(handler);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObligationhandler(Collection<AbstractObligationHandler> handlers) {
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.addAll(handlers);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObligationHandler(AbstractObligationHandler handler) {
        if (handler == null) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.remove(handler);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processObligations(AuthorizationRequestServlet.AuthzRequestMessageContext requestContext, ResultType result) throws ObligationProcessingException {
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            Iterator<AbstractObligationHandler> handlerItr = this.obligationHandlers.iterator();
            Map<String, ObligationType> effectiveObligations = this.preprocessObligations(result);
            this.log.debug("Obligations in effect for this result: {}", effectiveObligations.keySet());
            while (handlerItr.hasNext()) {
                AbstractObligationHandler handler = handlerItr.next();
                if (!effectiveObligations.containsKey(handler.getObligationId())) continue;
                this.log.debug("Processing obligation {}", (Object)handler.getObligationId());
                handler.evaluateObligation(requestContext, result);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    protected Map<String, ObligationType> preprocessObligations(ResultType result) {
        HashMap<String, ObligationType> effectiveObligations = new HashMap<String, ObligationType>();
        ObligationsType obligations = result.getObligations();
        if (obligations == null || obligations.getObligations().isEmpty()) {
            return effectiveObligations;
        }
        for (ObligationType obligation : obligations.getObligations()) {
            if (!this.isObligationInEffect(obligation, result)) continue;
            effectiveObligations.put(obligation.getObligationId(), obligation);
        }
        return effectiveObligations;
    }

    private boolean isObligationInEffect(ObligationType obligation, ResultType result) {
        if (obligation == null || result == null || result.getDecision() == null) {
            return false;
        }
        switch (obligation.getFulfillOn()) {
            case Deny: {
                if (result.getDecision().getDecision() != DecisionType.DECISION.Deny) break;
                return true;
            }
            case Permit: {
                if (result.getDecision().getDecision() != DecisionType.DECISION.Permit) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObligationHandlerComparator
    implements Comparator<AbstractObligationHandler> {
        private ObligationHandlerComparator() {
        }

        @Override
        public int compare(AbstractObligationHandler o1, AbstractObligationHandler o2) {
            if (o1.getHandlerPrecedence() == o2.getHandlerPrecedence()) {
                return o1.getObligationId().compareTo(o2.getObligationId());
            }
            if (o1.getHandlerPrecedence() < o2.getHandlerPrecedence()) {
                return -1;
            }
            return 1;
        }
    }
}

