/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.obligation;

import java.util.StringTokenizer;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.AbstractIniServiceConfigurationParser;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pdp.obligation.AbstractObligationHandler;
import org.glite.authz.pdp.obligation.IniOHConfigurationParser;
import org.glite.authz.pdp.obligation.ObligationService;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniOHConfigurationParserHelper {
    public static final String OH_PROP = "obligationHandlers";
    private static final Logger LOG = LoggerFactory.getLogger(IniOHConfigurationParserHelper.class);

    public static ObligationService processObligationHandlers(Ini iniFile, Profile.Section configSection, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        ObligationService service = new ObligationService();
        if (configSection.containsKey((Object)OH_PROP)) {
            StringTokenizer obligationHandlers = new StringTokenizer((String)configSection.get((Object)OH_PROP), " ");
            while (obligationHandlers.hasMoreTokens()) {
                String obligationHandlerName = Strings.safeTrimOrNullString((String)obligationHandlers.nextToken());
                if (!iniFile.containsKey((Object)obligationHandlerName)) {
                    String errorMsg = "INI configuration file does not contain a configuration section for obligation handler " + obligationHandlerName;
                    LOG.error(errorMsg);
                    throw new ConfigurationException(errorMsg);
                }
                if (obligationHandlerName == null) continue;
                service.addObligationhandler(IniOHConfigurationParserHelper.buildObligationHandler((Profile.Section)iniFile.get((Object)obligationHandlerName), configBuilder));
                LOG.info("Added obligation handler: {}", (Object)obligationHandlerName);
            }
        }
        return service;
    }

    private static AbstractObligationHandler buildObligationHandler(Profile.Section ohConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        LOG.info("Loading Obligation Handler {}", (Object)ohConfig.getName());
        String parserClassName = IniConfigUtil.getString((Profile.Section)ohConfig, (String)"parserClass");
        try {
            Class<?> parserClass = AbstractIniServiceConfigurationParser.class.getClassLoader().loadClass(parserClassName);
            IniOHConfigurationParser parser = (IniOHConfigurationParser)parserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return parser.parse(ohConfig, configBuilder);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to configure Obligation Handler " + ohConfig.getName() + ". The following error was reported: " + e.getMessage(), e);
        }
    }
}

