/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.obligation;

import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pdp.obligation.ObligationProcessingException;
import org.glite.authz.pdp.server.AuthorizationRequestServlet;
import org.opensaml.xacml.ctx.ResultType;

@ThreadSafe
public abstract class AbstractObligationHandler {
    private String id;
    private int precedence;

    protected AbstractObligationHandler(String obligationId) {
        this(obligationId, 0);
    }

    protected AbstractObligationHandler(String obligationId, int handlerPrecedence) {
        this.id = Strings.safeTrimOrNullString((String)obligationId);
        if (this.id == null) {
            throw new IllegalArgumentException("Provided obligation ID may not be null or empty");
        }
        if (handlerPrecedence < 0) {
            throw new IllegalArgumentException("Handler precedence must be 0 or greater");
        }
        this.precedence = handlerPrecedence;
    }

    public String getObligationId() {
        return this.id;
    }

    public int getHandlerPrecedence() {
        return this.precedence;
    }

    public abstract void evaluateObligation(AuthorizationRequestServlet.AuthzRequestMessageContext var1, ResultType var2) throws ObligationProcessingException;

    public int hashCode() {
        return this.getObligationId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractObligationHandler) {
            return Strings.safeEquals((Object)this.getObligationId(), (Object)((AbstractObligationHandler)obj).getObligationId());
        }
        return false;
    }
}

