/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.config;

import java.io.Reader;
import java.util.List;
import java.util.StringTokenizer;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.config.AbstractIniServiceConfigurationParser;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.pdp.config.PDPConfiguration;
import org.glite.authz.pdp.config.PDPConfigurationBuilder;
import org.glite.authz.pdp.obligation.IniOHConfigurationParserHelper;
import org.glite.authz.pdp.obligation.ObligationService;
import org.glite.authz.pdp.pip.IniPIPConfigurationParserHelper;
import org.glite.authz.pdp.pip.PolicyInformationPoint;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.provider.BasicSecurityPolicy;
import org.opensaml.ws.security.provider.MandatoryAuthenticatedMessageRule;
import org.opensaml.ws.security.provider.MandatoryIssuerRule;
import org.opensaml.ws.soap.client.SOAPClient;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.opensaml.ws.soap.client.http.HttpSOAPClient;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class PDPIniConfigurationParser
extends AbstractIniServiceConfigurationParser<PDPConfiguration> {
    public static final String POLICY_SECTION_HEADER = "POLICY";
    public static final String PAP_PROP = "paps";
    public static final String POLICY_RETENTION_PROP = "retentionInterval";
    public static final String CLOCK_SKEW_PROP = "clockSkew";
    public static final String MESSAGE_VALIDITY_PROP = "messageValidityPeriod";
    public static final int DEFAULT_PORT = 8152;
    public static final int DEFAULT_ADMIN_PORT = 8153;
    public static final int DEFAULT_POLICY_RETENTION = 240;
    public static final int DEFAULT_CLOCK_SKEW = 30;
    public static final int DEFAULT_MESSAGE_VALIDITY = 300;
    private final Logger log = LoggerFactory.getLogger(PDPIniConfigurationParser.class);

    protected int getPort(Profile.Section configSection) {
        return IniConfigUtil.getInt((Profile.Section)configSection, (String)"port", (int)8152, (int)1, (int)65535);
    }

    protected int getAdminPort(Profile.Section configSection) {
        return IniConfigUtil.getInt((Profile.Section)configSection, (String)"adminPort", (int)8153, (int)1, (int)65535);
    }

    protected PDPConfiguration parseIni(Reader iniReader) throws ConfigurationException {
        Ini pdpIni = new Ini();
        try {
            this.log.info("Loading and parsing INI configuration file");
            pdpIni.load(iniReader);
        }
        catch (Exception e) {
            this.log.error("Unable to load and parse the INI configuration file", (Throwable)e);
            throw new ConfigurationException("Unable to parse INI configuration file", e);
        }
        PDPConfigurationBuilder configBuilder = new PDPConfigurationBuilder();
        this.log.info("Processing PDP {} configuration section", (Object)"SECURITY");
        this.processSecuritySection(pdpIni, configBuilder);
        this.log.info("Processing PDP {} configuration section", (Object)"SERVICE");
        this.processServiceSection(pdpIni, configBuilder);
        Profile.Section serviceSection = (Profile.Section)pdpIni.get((Object)"SERVICE");
        List<PolicyInformationPoint> pips = IniPIPConfigurationParserHelper.processPolicyInformationPoints(pdpIni, serviceSection, configBuilder);
        this.log.info("Total policy information points: {}", (Object)pips.size());
        configBuilder.getPolicyInformationPoints().addAll(pips);
        ObligationService service = IniOHConfigurationParserHelper.processObligationHandlers(pdpIni, serviceSection, configBuilder);
        this.log.info("Total obligation handlers: {}", (Object)service.getObligationHandlers().size());
        configBuilder.setObligationService(service);
        this.log.info("Processing PDP {} configuration section", (Object)POLICY_SECTION_HEADER);
        this.processPAPConfiguration(pdpIni, configBuilder);
        return configBuilder.build();
    }

    protected void processPAPConfiguration(Ini iniFile, PDPConfigurationBuilder configBuilder) throws ConfigurationException {
        Profile.Section configSection = (Profile.Section)iniFile.get((Object)POLICY_SECTION_HEADER);
        if (configSection == null) {
            String errorMsg = "PDP INI configuration does not contain the rquired 'POLICY' INI section";
            this.log.error(errorMsg);
            throw new ConfigurationException(errorMsg);
        }
        String name = configSection.getName();
        String papsStr = IniConfigUtil.getString((Profile.Section)configSection, (String)PAP_PROP);
        this.log.info("{}: PAP endpoints: {}", (Object)name, (Object)papsStr);
        StringTokenizer paps = new StringTokenizer((String)configSection.get((Object)PAP_PROP), " ");
        while (paps.hasMoreTokens()) {
            configBuilder.getPAPEndpoints().add(paps.nextToken());
        }
        int policyRetentionInterval = IniConfigUtil.getInt((Profile.Section)configSection, (String)POLICY_RETENTION_PROP, (int)240, (int)1, (int)Integer.MAX_VALUE);
        this.log.info("{}: Policy retention interval: {} minutes", (Object)name, (Object)policyRetentionInterval);
        configBuilder.setPolicyRetentionInterval(policyRetentionInterval);
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.setMaxPoolSize(1);
        HttpClientBuilder soapClientBuilder = this.buildSOAPClientBuilder(configSection, configBuilder.getKeyManager(), configBuilder.getTrustManager());
        configBuilder.setSoapClient((SOAPClient)new HttpSOAPClient(soapClientBuilder.buildClient(), (ParserPool)parserPool));
    }

    protected SecurityPolicy buildSecurityPolicy(Profile.Section configSection) {
        BasicSecurityPolicy securityPolicy = new BasicSecurityPolicy();
        int clockSkew = IniConfigUtil.getInt((Profile.Section)configSection, (String)CLOCK_SKEW_PROP, (int)30, (int)1, (int)Integer.MAX_VALUE);
        int messageValidityPeriod = IniConfigUtil.getInt((Profile.Section)configSection, (String)MESSAGE_VALIDITY_PROP, (int)300, (int)1, (int)Integer.MAX_VALUE);
        this.log.info("SAML message validating: {} seconds with a {} second clock skew", (Object)messageValidityPeriod, (Object)clockSkew);
        IssueInstantRule issueInstant = new IssueInstantRule(clockSkew, messageValidityPeriod);
        securityPolicy.getPolicyRules().add(issueInstant);
        securityPolicy.getPolicyRules().add(new MandatoryIssuerRule());
        securityPolicy.getPolicyRules().add(new MandatoryAuthenticatedMessageRule());
        return securityPolicy;
    }
}

