/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.config;

import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.glite.authz.common.config.AbstractServiceConfiguration;
import org.glite.authz.common.config.AbstractServiceConfigurationBuilder;
import org.glite.authz.pdp.config.PDPConfiguration;
import org.glite.authz.pdp.obligation.ObligationService;
import org.glite.authz.pdp.pip.PolicyInformationPoint;
import org.opensaml.ws.security.SecurityPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class PDPConfigurationBuilder
extends AbstractServiceConfigurationBuilder<PDPConfiguration> {
    private List<String> papEndpoints;
    private int policyRetentionInterval;
    private String policySetId;
    private SecurityPolicy authzDecisionQuerySecurityPolicy;
    private List<PolicyInformationPoint> pips;
    private ObligationService obligationService;

    public PDPConfigurationBuilder() {
        this.papEndpoints = new ArrayList<String>();
        this.policyRetentionInterval = 240;
        this.policySetId = "-1";
        this.pips = new ArrayList<PolicyInformationPoint>();
    }

    public PDPConfigurationBuilder(PDPConfiguration prototype) {
        super((AbstractServiceConfiguration)prototype);
        this.papEndpoints = prototype.getPAPEndpointss();
        this.policyRetentionInterval = prototype.getPolicyRetentionInterval();
        this.policySetId = prototype.getPolicySetId();
    }

    public PDPConfiguration build() {
        PDPConfiguration config = new PDPConfiguration();
        this.populateConfiguration(config);
        config.setPAPEndpoints(this.papEndpoints);
        config.setPolicyRetentionInterval(this.policyRetentionInterval);
        config.setPolicySetId(this.policySetId);
        config.setObligationService(this.obligationService);
        config.setPolicyInformationPoints(this.pips);
        return config;
    }

    public SecurityPolicy getAuthzDecisionQuerySecurityPolicy() {
        return this.authzDecisionQuerySecurityPolicy;
    }

    public List<String> getPAPEndpoints() {
        return this.papEndpoints;
    }

    public int getPolicyRetentionInterval() {
        return this.policyRetentionInterval;
    }

    public String getPolicySetId() {
        return this.policySetId;
    }

    public void setAuthzDecisionQuerySecurityPolicy(SecurityPolicy policy) {
        this.authzDecisionQuerySecurityPolicy = policy;
    }

    public void setPolicyRetentionInterval(int interval) {
        this.policyRetentionInterval = interval;
    }

    public void setPolicySetId(String id) {
        this.policySetId = id;
    }

    public List<PolicyInformationPoint> getPolicyInformationPoints() {
        return this.pips;
    }

    public ObligationService getObligationService() {
        return this.obligationService;
    }

    public void setObligationService(ObligationService service) {
        this.obligationService = service;
    }
}

